/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.asserttoif;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.siyeh.ipp.base.PsiElementPredicate;

class IfStatementPredicate
implements PsiElementPredicate {
    IfStatementPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.IF_KEYWORD) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement statement = (PsiIfStatement)parent;
        PsiStatement elseBranch = statement.getElseBranch();
        if (elseBranch != null) {
            return false;
        }
        PsiStatement thenBranch = statement.getThenBranch();
        return IfStatementPredicate.isSimpleThrowStatement(thenBranch);
    }

    public static boolean isSimpleThrowStatement(PsiStatement element) {
        if (element instanceof PsiThrowStatement) {
            return true;
        }
        if (element instanceof PsiBlockStatement) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)element;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiStatement[] statements = codeBlock.getStatements();
            if (statements.length != 1) {
                return false;
            }
            PsiStatement statement = statements[0];
            return IfStatementPredicate.isSimpleThrowStatement(statement);
        }
        return false;
    }
}

