/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.annotation;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ipp.annotation.ExpandToNormalAnnotationPredicate;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class ExpandToNormalAnnotationIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        PsiNameValuePair annotation = (PsiNameValuePair)element;
        String text = ExpandToNormalAnnotationIntention.buildReplacementText(annotation);
        return IntentionPowerPackBundle.message("expand.to.normal.annotation.name", text);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        ExpandToNormalAnnotationPredicate expandToNormalAnnotationPredicate = new ExpandToNormalAnnotationPredicate();
        if (expandToNormalAnnotationPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/annotation/ExpandToNormalAnnotationIntention", "getElementPredicate"));
        }
        return expandToNormalAnnotationPredicate;
    }

    public static String buildReplacementText(PsiNameValuePair attribute) {
        StringBuilder text = new StringBuilder();
        PsiAnnotationMemberValue value = attribute.getValue();
        text.append("value = ");
        if (value != null) {
            text.append(value.getText());
        }
        return text.toString();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ipp/annotation/ExpandToNormalAnnotationIntention", "processIntention"));
        }
        PsiNameValuePair attribute = (PsiNameValuePair)element;
        int textOffset = attribute.getTextOffset();
        Project project = attribute.getProject();
        String text = ExpandToNormalAnnotationIntention.buildReplacementText(attribute);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiAnnotation newAnnotation = factory.createAnnotationFromText("@A(" + text + " )", (PsiElement)attribute);
        attribute.replace((PsiElement)newAnnotation.getParameterList().getAttributes()[0]);
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        Editor editor = editorManager.getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        CaretModel caretModel = editor.getCaretModel();
        caretModel.moveToOffset(textOffset + text.length() - 1);
    }
}

