/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.ui;

import com.intellij.codeInspection.InspectionProfileEntry;
import java.lang.reflect.Field;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TextField
extends JTextField {
    public TextField(@NotNull InspectionProfileEntry owner, @NonNls String property) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/ui/TextField", "<init>"));
        }
        super(TextField.getPropertyValue(owner, property));
        TextFieldDocumentListener documentListener = new TextFieldDocumentListener(owner, property);
        this.getDocument().addDocumentListener(documentListener);
    }

    private static String getPropertyValue(InspectionProfileEntry owner, String property) {
        try {
            Class<?> aClass = owner.getClass();
            Field field = aClass.getField(property);
            return (String)field.get(owner);
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
        catch (NoSuchFieldException ignore) {
            return null;
        }
    }

    private static void setPropertyValue(InspectionProfileEntry owner, String property, String value) {
        try {
            Class<?> aClass = owner.getClass();
            Field field = aClass.getField(property);
            field.set(owner, value);
        }
        catch (IllegalAccessException ignore) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private class TextFieldDocumentListener
    implements DocumentListener {
        private final InspectionProfileEntry owner;
        private final String property;

        public TextFieldDocumentListener(InspectionProfileEntry owner, String property) {
            this.owner = owner;
            this.property = property;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.textChanged();
        }

        private void textChanged() {
            TextField.setPropertyValue(this.owner, this.property, TextField.this.getText());
        }
    }
}

