/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.telemetry;

import com.siyeh.ig.telemetry.InspectionRunTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class InspectionGadgetsTelemetry {
    private static final InspectionGadgetsTelemetry telemetry = new InspectionGadgetsTelemetry();
    private static volatile boolean telemetryEnabled = false;
    private final ConcurrentHashMap<String, InspectionRunTime> inspectionRunTimes = new ConcurrentHashMap();

    public List<InspectionRunTime> buildList() {
        if (this.inspectionRunTimes.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<InspectionRunTime>(this.inspectionRunTimes.values());
    }

    public void reportRun(String inspectionID, long runTime) {
        InspectionRunTime oldValue;
        InspectionRunTime inspectionRunTime = this.inspectionRunTimes.get(inspectionID);
        if (inspectionRunTime == null && (oldValue = this.inspectionRunTimes.putIfAbsent(inspectionID, inspectionRunTime = new InspectionRunTime(inspectionID))) != null) {
            inspectionRunTime = oldValue;
        }
        inspectionRunTime.addRunTime(runTime);
    }

    public void reset() {
        this.inspectionRunTimes.clear();
    }

    public static boolean isEnabled() {
        return telemetryEnabled;
    }

    public static void setEnabled(boolean enabled) {
        telemetryEnabled = enabled;
        if (telemetryEnabled) {
            telemetry.reset();
        }
    }

    @NotNull
    public static InspectionGadgetsTelemetry getInstance() {
        InspectionGadgetsTelemetry inspectionGadgetsTelemetry = telemetry;
        if (inspectionGadgetsTelemetry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/telemetry/InspectionGadgetsTelemetry", "getInstance"));
        }
        return inspectionGadgetsTelemetry;
    }
}

