/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.VariableSearchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryThisInspection
extends BaseInspection {
    public boolean ignoreAssignments = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.this.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryThisInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.this.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryThisInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("unnecessary.this.ignore.assignments.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAssignments");
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryThisFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryThisVisitor();
    }

    private class UnnecessaryThisVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryThisVisitor() {
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/style/UnnecessaryThisInspection$UnnecessaryThisVisitor", "visitReferenceExpression"));
            }
            super.visitReferenceExpression(expression);
            PsiReferenceParameterList parameterList = expression.getParameterList();
            if (parameterList == null) {
                return;
            }
            if (parameterList.getTypeArguments().length > 0) {
                return;
            }
            PsiExpression qualifierExpression = expression.getQualifierExpression();
            if (!(qualifierExpression instanceof PsiThisExpression)) {
                return;
            }
            PsiThisExpression thisExpression = (PsiThisExpression)qualifierExpression;
            PsiJavaCodeReferenceElement qualifier = thisExpression.getQualifier();
            String referenceName = expression.getReferenceName();
            if (referenceName == null) {
                return;
            }
            if (UnnecessaryThisInspection.this.ignoreAssignments && PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (qualifier == null) {
                if (parent instanceof PsiCallExpression) {
                    this.registerError((PsiElement)qualifierExpression, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                    return;
                }
                PsiElement target = expression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                if (!VariableSearchUtils.variableNameResolvesToTarget(referenceName, variable, (PsiElement)expression)) {
                    return;
                }
                this.registerError((PsiElement)thisExpression, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
            } else {
                String qualifierName = qualifier.getReferenceName();
                if (qualifierName == null) {
                    return;
                }
                if (parent instanceof PsiCallExpression) {
                    PsiCallExpression callExpression = (PsiCallExpression)parent;
                    PsiMethod calledMethod = callExpression.resolveMethod();
                    if (calledMethod == null) {
                        return;
                    }
                    String methodName = calledMethod.getName();
                    PsiClass parentClass = ClassUtils.getContainingClass((PsiElement)expression);
                    Project project = expression.getProject();
                    JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
                    PsiResolveHelper resolveHelper = psiFacade.getResolveHelper();
                    while (parentClass != null) {
                        PsiMethod[] methods;
                        if (qualifierName.equals(parentClass.getName())) {
                            this.registerError((PsiElement)thisExpression, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                        }
                        for (PsiMethod method : methods = parentClass.findMethodsByName(methodName, true)) {
                            PsiClass containingClass = method.getContainingClass();
                            if (!resolveHelper.isAccessible((PsiMember)method, (PsiElement)expression, null) || method.hasModifierProperty("private") && !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)expression, (boolean)true)) continue;
                            return;
                        }
                        parentClass = ClassUtils.getContainingClass((PsiElement)parentClass);
                    }
                } else {
                    PsiElement target = expression.resolve();
                    if (!(target instanceof PsiVariable)) {
                        return;
                    }
                    PsiVariable variable = (PsiVariable)target;
                    if (!VariableSearchUtils.variableNameResolvesToTarget(referenceName, variable, (PsiElement)expression)) {
                        return;
                    }
                    PsiClass parentClass = ClassUtils.getContainingClass((PsiElement)expression);
                    while (parentClass != null) {
                        PsiField field;
                        if (qualifierName.equals(parentClass.getName())) {
                            this.registerError((PsiElement)thisExpression, ProblemHighlightType.LIKE_UNUSED_SYMBOL, new Object[0]);
                        }
                        if ((field = parentClass.findFieldByName(referenceName, true)) != null) {
                            return;
                        }
                        parentClass = ClassUtils.getContainingClass((PsiElement)parentClass);
                    }
                }
            }
        }
    }

    private static class UnnecessaryThisFix
    extends InspectionGadgetsFix {
        private UnnecessaryThisFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.this.remove.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryThisInspection$UnnecessaryThisFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/UnnecessaryThisInspection$UnnecessaryThisFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement thisToken = descriptor.getPsiElement();
            PsiReferenceExpression thisExpression = (PsiReferenceExpression)thisToken.getParent();
            assert (thisExpression != null);
            String newExpression = thisExpression.getReferenceName();
            if (newExpression == null) {
                return;
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)thisExpression, newExpression);
        }
    }
}

