/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SimplifiableAnnotationInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("simplifiable.annotation.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SimplifiableAnnotationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String replacement = (String)infos[0];
        String string = InspectionGadgetsBundle.message("simplifiable.annotation.problem.descriptor", replacement);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SimplifiableAnnotationInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String replacement = (String)infos[0];
        return new SimplifiableAnnotationFix(replacement);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SimplifiableAnnotationVisitor();
    }

    private static class SimplifiableAnnotationVisitor
    extends BaseInspectionVisitor {
        private SimplifiableAnnotationVisitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            PsiElement child;
            super.visitAnnotation(annotation);
            PsiAnnotationParameterList parameterList = annotation.getParameterList();
            PsiJavaCodeReferenceElement nameReferenceElement = annotation.getNameReferenceElement();
            if (nameReferenceElement == null) {
                return;
            }
            PsiNameValuePair[] attributes = parameterList.getAttributes();
            PsiElement[] annotationChildren = annotation.getChildren();
            if (annotationChildren.length >= 2 && (child = annotationChildren[1]) instanceof PsiWhiteSpace) {
                String annotationName = nameReferenceElement.getText();
                String replacementText = attributes.length > 0 ? '@' + annotationName + parameterList.getText() : '@' + annotationName;
                this.registerError((PsiElement)annotation, replacementText);
                return;
            }
            if (attributes.length == 0) {
                PsiElement[] children = parameterList.getChildren();
                if (children.length <= 0) {
                    return;
                }
                String annotationName = nameReferenceElement.getText();
                this.registerError((PsiElement)annotation, '@' + annotationName);
            } else if (attributes.length == 1) {
                String attributeValueText;
                PsiNameValuePair attribute = attributes[0];
                String name = attribute.getName();
                PsiAnnotationMemberValue attributeValue = attribute.getValue();
                if (attributeValue == null) {
                    return;
                }
                if (!"value".equals(name)) {
                    if (!(attributeValue instanceof PsiArrayInitializerMemberValue)) {
                        return;
                    }
                    PsiArrayInitializerMemberValue arrayValue = (PsiArrayInitializerMemberValue)attributeValue;
                    PsiAnnotationMemberValue[] initializers = arrayValue.getInitializers();
                    if (initializers.length != 1) {
                        return;
                    }
                    attributeValueText = name == null ? initializers[0].getText() : name + '=' + initializers[0].getText();
                } else {
                    attributeValueText = SimplifiableAnnotationVisitor.getAttributeValueText(attributeValue);
                }
                String annotationName = nameReferenceElement.getText();
                String replacementText = '@' + annotationName + '(' + attributeValueText + ')';
                this.registerError((PsiElement)annotation, replacementText);
            }
        }

        private static String getAttributeValueText(PsiAnnotationMemberValue value) {
            PsiArrayInitializerMemberValue arrayValue;
            PsiAnnotationMemberValue[] initializers;
            if (value instanceof PsiArrayInitializerMemberValue && (initializers = (arrayValue = (PsiArrayInitializerMemberValue)value).getInitializers()).length == 1) {
                return initializers[0].getText();
            }
            return value.getText();
        }
    }

    private static class SimplifiableAnnotationFix
    extends InspectionGadgetsFix {
        private final String replacement;

        public SimplifiableAnnotationFix(String replacement) {
            this.replacement = replacement;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("simplifiable.annotation.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SimplifiableAnnotationInspection$SimplifiableAnnotationFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/SimplifiableAnnotationInspection$SimplifiableAnnotationFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiAnnotation)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiAnnotation annotation = factory.createAnnotationFromText(this.replacement, element);
            element.replace((PsiElement)annotation);
        }
    }
}

