/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EqualsCalledOnEnumConstantInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("equals.called.on.enum.constant.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/EqualsCalledOnEnumConstantInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("equals.called.on.enum.constant.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/EqualsCalledOnEnumConstantInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiElement element = (PsiElement)infos[0];
        PsiElement parent = element.getParent();
        if (parent instanceof PsiExpressionStatement) {
            return null;
        }
        return new EqualsCalledOnEnumValueFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsCalledOnEnumValueVisitor();
    }

    private static class EqualsCalledOnEnumValueVisitor
    extends BaseInspectionVisitor {
        private EqualsCalledOnEnumValueVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/style/EqualsCalledOnEnumConstantInspection$EqualsCalledOnEnumValueVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            if (!MethodCallUtils.isEqualsCall(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null || !TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.lang.Enum")) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            PsiType comparedTypeErasure = TypeConversionUtil.erasure((PsiType)qualifier.getType());
            PsiType comparisonTypeErasure = TypeConversionUtil.erasure((PsiType)arguments[0].getType());
            if (comparedTypeErasure == null || comparisonTypeErasure == null || !TypeConversionUtil.areTypesConvertible((PsiType)comparedTypeErasure, (PsiType)comparisonTypeErasure)) {
                return;
            }
            this.registerMethodCallError(expression, expression);
        }
    }

    private static class EqualsCalledOnEnumValueFix
    extends InspectionGadgetsFix {
        private EqualsCalledOnEnumValueFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/EqualsCalledOnEnumConstantInspection$EqualsCalledOnEnumValueFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("equals.called.on.enum.constant.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/EqualsCalledOnEnumConstantInspection$EqualsCalledOnEnumValueFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            boolean not;
            PsiPrefixExpression prefixExpression;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (parent == null) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length > 1) {
                return;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            StringBuilder newExpression = new StringBuilder();
            PsiElement greatGrandParent = grandParent.getParent();
            if (greatGrandParent instanceof PsiPrefixExpression) {
                prefixExpression = (PsiPrefixExpression)greatGrandParent;
                IElementType tokenType = prefixExpression.getOperationTokenType();
                not = JavaTokenType.EXCL == tokenType;
            } else {
                prefixExpression = null;
                not = false;
            }
            newExpression.append(qualifier.getText());
            if (not) {
                newExpression.append("!=");
            } else {
                newExpression.append("==");
            }
            if (arguments.length == 1) {
                newExpression.append(arguments[0].getText());
            }
            if (not) {
                PsiReplacementUtil.replaceExpression((PsiExpression)prefixExpression, newExpression.toString());
            } else {
                PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString());
            }
        }
    }
}

