/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SerializableWithUnconstructableAncestorInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("SerializableClassWithUnconstructableAncestor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableWithUnconstructableAncestorInspection", "getID"));
        }
        return "SerializableClassWithUnconstructableAncestor";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("serializable.with.unconstructable.ancestor.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableWithUnconstructableAncestorInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass ancestor = (PsiClass)infos[0];
        String string = InspectionGadgetsBundle.message("serializable.with.unconstructable.ancestor.problem.descriptor", ancestor.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/serialization/SerializableWithUnconstructableAncestorInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SerializableWithUnconstructableAncestorVisitor();
    }

    private static class SerializableWithUnconstructableAncestorVisitor
    extends BaseInspectionVisitor {
        private SerializableWithUnconstructableAncestorVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/serialization/SerializableWithUnconstructableAncestorInspection$SerializableWithUnconstructableAncestorVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isAnnotationType()) {
                return;
            }
            if (!SerializationUtils.isSerializable(aClass) || SerializationUtils.hasWriteReplace(aClass)) {
                return;
            }
            PsiClass ancestor = aClass.getSuperClass();
            HashSet<PsiClass> visitedClasses = new HashSet<PsiClass>(8);
            while (ancestor != null && SerializationUtils.isSerializable(ancestor)) {
                if (SerializationUtils.hasWriteReplace(ancestor)) {
                    return;
                }
                if (visitedClasses.add(ancestor = ancestor.getSuperClass())) continue;
                return;
            }
            if (ancestor == null || SerializableWithUnconstructableAncestorVisitor.classHasNoArgConstructor(ancestor)) {
                return;
            }
            this.registerClassError(aClass, ancestor);
        }

        private static boolean classHasNoArgConstructor(PsiClass aClass) {
            boolean hasConstructor = false;
            boolean hasNoArgConstructor = false;
            for (PsiMethod constructor : aClass.getConstructors()) {
                hasConstructor = true;
                PsiParameterList parameterList = constructor.getParameterList();
                if (parameterList.getParametersCount() != 0 || !constructor.hasModifierProperty("public") && !constructor.hasModifierProperty("protected")) continue;
                hasNoArgConstructor = true;
            }
            return hasNoArgConstructor || !hasConstructor;
        }
    }
}

