/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public abstract class SerializableInspectionBase
extends BaseInspection {
    private static final JComponent[] EMPTY_COMPONENT_ARRAY = new JComponent[0];
    public boolean ignoreAnonymousInnerClasses = false;
    @Deprecated
    public String superClassString = "java.awt.Component";
    protected List<String> superClassList = new ArrayList<String>();

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/serialization/SerializableInspectionBase", "readSettings"));
        }
        super.readSettings(node);
        SerializableInspectionBase.parseString(this.superClassString, this.superClassList);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/serialization/SerializableInspectionBase", "writeSettings"));
        }
        this.superClassString = SerializableInspectionBase.formatString(this.superClassList);
        super.writeSettings(node);
    }

    protected JComponent[] createAdditionalOptions() {
        return EMPTY_COMPONENT_ARRAY;
    }

    protected boolean isIgnoredSubclass(PsiClass aClass) {
        if (SerializationUtils.isDirectlySerializable(aClass)) {
            return false;
        }
        for (String superClassName : this.superClassList) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)superClassName)) continue;
            return true;
        }
        return false;
    }

    public String getAlternativeID() {
        return "serial";
    }
}

