/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.serialization;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SerializationUtils;
import com.siyeh.ig.serialization.SerializableInspectionBase;
import org.jetbrains.annotations.NotNull;

class SerializableInnerClassHasSerialVersionUIDFieldVisitor
extends BaseInspectionVisitor {
    private final SerializableInspectionBase inspection;

    public SerializableInnerClassHasSerialVersionUIDFieldVisitor(SerializableInspectionBase inspection) {
        this.inspection = inspection;
    }

    public void visitClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/serialization/SerializableInnerClassHasSerialVersionUIDFieldVisitor", "visitClass"));
        }
        if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
            return;
        }
        if (this.inspection.ignoreAnonymousInnerClasses && aClass instanceof PsiAnonymousClass) {
            return;
        }
        if (SerializableInnerClassHasSerialVersionUIDFieldVisitor.hasSerialVersionUIDField(aClass)) {
            return;
        }
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass == null) {
            return;
        }
        if (aClass.hasModifierProperty("static")) {
            return;
        }
        if (!SerializationUtils.isSerializable(aClass)) {
            return;
        }
        if (this.inspection.isIgnoredSubclass(aClass)) {
            return;
        }
        this.registerClassError(aClass, new Object[0]);
    }

    private static boolean hasSerialVersionUIDField(PsiClass aClass) {
        PsiField[] fields = aClass.getFields();
        boolean hasSerialVersionUID = false;
        for (PsiField field : fields) {
            String fieldName = field.getName();
            if (!"serialVersionUID".equals(fieldName)) continue;
            hasSerialVersionUID = true;
        }
        return hasSerialVersionUID;
    }
}

