/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeserializableClassInSecureContextInspection
extends BaseInspection {
    public boolean ignoreThrowable = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("deserializable.class.in.secure.context.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/DeserializableClassInSecureContextInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("deserializable.class.in.secure.context.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/DeserializableClassInSecureContextInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.classes.extending.throwable.option", new Object[0]), (InspectionProfileEntry)this, "ignoreThrowable");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new DeserializableClassInSecureContextVisitor();
    }

    public String getAlternativeID() {
        return "serial";
    }

    private class DeserializableClassInSecureContextVisitor
    extends BaseInspectionVisitor {
        private DeserializableClassInSecureContextVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiMethod[] methods;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/security/DeserializableClassInSecureContextInspection$DeserializableClassInSecureContextVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter || !SerializationUtils.isSerializable(aClass)) {
                return;
            }
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!SerializationUtils.isReadObject(method)) continue;
                if (!ControlFlowUtils.methodAlwaysThrowsException(method)) break;
                return;
            }
            if (DeserializableClassInSecureContextInspection.this.ignoreThrowable && InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)false, (String)"java.lang.Throwable")) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

