/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.security;

import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class CustomClassloaderInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("custom.classloader.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/CustomClassloaderInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("custom.classloader.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/security/CustomClassloaderInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CustomClassloaderVisitor();
    }

    private static class CustomClassloaderVisitor
    extends BaseInspectionVisitor {
        private CustomClassloaderVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/security/CustomClassloaderInspection$CustomClassloaderVisitor", "visitClass"));
            }
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.ClassLoader")) {
                return;
            }
            if ("java.lang.ClassLoader".equals(aClass.getQualifiedName())) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

