/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import org.jetbrains.annotations.NotNull;

class VariableUsedInInnerClassVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean usedInInnerClass;
    private boolean inInnerClass;

    public VariableUsedInInnerClassVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor", "<init>"));
        }
        this.usedInInnerClass = false;
        this.inInnerClass = false;
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor", "visitElement"));
        }
        if (!this.usedInInnerClass) {
            super.visitElement(element);
        }
    }

    public void visitClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor", "visitClass"));
        }
        if (this.usedInInnerClass) {
            return;
        }
        boolean wasInInnerClass = this.inInnerClass;
        if (!this.inInnerClass) {
            this.inInnerClass = true;
            for (PsiElement child = aClass.getLBrace(); child != null; child = child.getNextSibling()) {
                child.accept((PsiElementVisitor)this);
            }
        } else {
            this.inInnerClass = true;
            super.visitClass(aClass);
        }
        this.inInnerClass = wasInInnerClass;
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/VariableUsedInInnerClassVisitor", "visitReferenceExpression"));
        }
        if (this.usedInInnerClass) {
            return;
        }
        super.visitReferenceExpression(referenceExpression);
        if (!this.inInnerClass) {
            return;
        }
        PsiElement target = referenceExpression.resolve();
        if (this.variable.equals(target)) {
            this.usedInInnerClass = true;
        }
    }

    public boolean isUsedInInnerClass() {
        return this.usedInInnerClass;
    }
}

