/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import org.jetbrains.annotations.NotNull;

public class SingletonUtil {
    private SingletonUtil() {
    }

    public static boolean isSingleton(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/SingletonUtil", "isSingleton"));
        }
        if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
            return false;
        }
        if (aClass instanceof PsiTypeParameter || aClass instanceof PsiAnonymousClass) {
            return false;
        }
        PsiMethod[] constructors = SingletonUtil.getIfOnlyInvisibleConstructors(aClass);
        if (constructors.length == 0) {
            return false;
        }
        PsiField selfInstance = SingletonUtil.getIfOneStaticSelfInstance(aClass);
        if (selfInstance == null) {
            return false;
        }
        return SingletonUtil.newOnlyAssignsToStaticSelfInstance(constructors[0], selfInstance);
    }

    private static PsiField getIfOneStaticSelfInstance(PsiClass aClass) {
        PsiField[] fields = aClass.getFields();
        PsiField result = null;
        for (PsiField field : fields) {
            PsiType type;
            String fieldTypeName;
            String className = aClass.getQualifiedName();
            if (!field.hasModifierProperty("static") || !(fieldTypeName = (type = field.getType()).getCanonicalText()).equals(className)) continue;
            if (result != null) {
                return null;
            }
            result = field;
        }
        return result;
    }

    private static PsiMethod[] getIfOnlyInvisibleConstructors(PsiClass aClass) {
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return PsiMethod.EMPTY_ARRAY;
        }
        for (PsiMethod constructor : constructors) {
            if (constructor.hasModifierProperty("public")) {
                return PsiMethod.EMPTY_ARRAY;
            }
            if (constructor.hasModifierProperty("private") || constructor.hasModifierProperty("protected")) continue;
            return PsiMethod.EMPTY_ARRAY;
        }
        return constructors;
    }

    private static boolean newOnlyAssignsToStaticSelfInstance(PsiMethod method, PsiField field) {
        Query search = MethodReferencesSearch.search((PsiMethod)method, (SearchScope)field.getUseScope(), (boolean)false);
        NewOnlyAssignedToFieldProcessor processor = new NewOnlyAssignedToFieldProcessor(field);
        search.forEach((Processor)processor);
        return processor.isNewOnlyAssignedToField();
    }

    private static class NewOnlyAssignedToFieldProcessor
    implements Processor<PsiReference> {
        private boolean newOnlyAssignedToField = true;
        private final PsiField field;

        public NewOnlyAssignedToFieldProcessor(PsiField field) {
            this.field = field;
        }

        public boolean process(PsiReference reference) {
            PsiElement element = reference.getElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiNewExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiElement grandParent = parent.getParent();
            if (this.field.equals(grandParent)) {
                return true;
            }
            if (!(grandParent instanceof PsiAssignmentExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)grandParent;
            PsiExpression lhs = assignmentExpression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
            PsiElement target = referenceExpression.resolve();
            if (!this.field.equals(target)) {
                this.newOnlyAssignedToField = false;
                return false;
            }
            return true;
        }

        public boolean isNewOnlyAssignedToField() {
            return this.newOnlyAssignedToField;
        }
    }
}

