/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallUtils {
    @NonNls
    private static final Set<String> regexMethodNames = new HashSet<String>(5);

    private MethodCallUtils() {
    }

    @Nullable
    public static String getMethodName(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/MethodCallUtils", "getMethodName"));
        }
        PsiReferenceExpression method = expression.getMethodExpression();
        return method.getReferenceName();
    }

    @Nullable
    public static PsiType getTargetType(@NotNull PsiMethodCallExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/MethodCallUtils", "getTargetType"));
        }
        PsiReferenceExpression method = expression.getMethodExpression();
        PsiExpression qualifierExpression = method.getQualifierExpression();
        if (qualifierExpression == null) {
            return null;
        }
        return qualifierExpression.getType();
    }

    public static boolean isEqualsCall(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!"equals".equals(name)) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        return MethodUtils.isEquals(method);
    }

    public static boolean isSimpleCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, String ... parameterTypeStrings) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/MethodCallUtils", "isSimpleCallToMethod"));
        }
        if (parameterTypeStrings == null) {
            return MethodCallUtils.isCallToMethod(expression, calledOnClassName, returnType, methodName, new PsiType[0]);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)expression.getProject());
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiType[] parameterTypes = PsiType.createArray((int)parameterTypeStrings.length);
        GlobalSearchScope scope = expression.getResolveScope();
        for (int i = 0; i < parameterTypeStrings.length; ++i) {
            String parameterTypeString = parameterTypeStrings[i];
            parameterTypes[i] = factory.createTypeByFQClassName(parameterTypeString, scope);
        }
        return MethodCallUtils.isCallToMethod(expression, calledOnClassName, returnType, methodName, parameterTypes);
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @Nullable Pattern methodNamePattern, PsiType ... parameterTypes) {
        PsiExpression qualifier;
        String referenceName;
        Matcher matcher;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/MethodCallUtils", "isCallToMethod"));
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        if (methodNamePattern != null && !(matcher = methodNamePattern.matcher(referenceName = methodExpression.getReferenceName())).matches()) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        if (calledOnClassName != null && (qualifier = methodExpression.getQualifierExpression()) != null) {
            if (!TypeUtils.expressionHasTypeOrSubtype(qualifier, calledOnClassName)) {
                return false;
            }
            return MethodUtils.methodMatches(method, null, returnType, methodNamePattern, parameterTypes);
        }
        return MethodUtils.methodMatches(method, calledOnClassName, returnType, methodNamePattern, parameterTypes);
    }

    public static boolean isCallToMethod(@NotNull PsiMethodCallExpression expression, @NonNls @Nullable String calledOnClassName, @Nullable PsiType returnType, @NonNls @Nullable String methodName, PsiType ... parameterTypes) {
        String referenceName;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/psiutils/MethodCallUtils", "isCallToMethod"));
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        if (methodName != null && !methodName.equals(referenceName = methodExpression.getReferenceName())) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        return MethodUtils.methodMatches(method, calledOnClassName, returnType, methodName, parameterTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isApplicable(PsiMethod method, PsiSubstitutor substitutorForMethod, PsiType[] types) {
        PsiParameterList parameterList = method.getParameterList();
        if (method.isVarArgs()) {
            PsiType lastArgType;
            if (types.length < parameterList.getParametersCount() - 1) {
                return false;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiParameter lastParameter = parameters[parameters.length - 1];
            PsiType lastParameterType = lastParameter.getType();
            if (!(lastParameterType instanceof PsiArrayType)) {
                return false;
            }
            lastParameterType = substitutorForMethod.substitute(lastParameterType);
            if (!lastParameter.isVarArgs()) return false;
            for (int i = 0; i < parameters.length - 1; ++i) {
                PsiParameter parameter = parameters[i];
                if (parameter.isVarArgs()) {
                    return false;
                }
                PsiType argumentType = types[i];
                if (argumentType == null) {
                    return false;
                }
                PsiType parameterType = parameters[i].getType();
                PsiType substitutedParameterType = substitutorForMethod.substitute(parameterType);
                if (TypeConversionUtil.isAssignable((PsiType)substitutedParameterType, (PsiType)argumentType)) continue;
                return false;
            }
            if (types.length == parameters.length && (lastArgType = types[types.length - 1]) != null && TypeConversionUtil.isAssignable((PsiType)lastParameterType, (PsiType)lastArgType)) {
                return true;
            }
            PsiArrayType arrayType = (PsiArrayType)lastParameterType;
            PsiType componentType = arrayType.getComponentType();
            for (int i = parameters.length - 1; i < types.length; ++i) {
                PsiType argType = types[i];
                if (argType != null && TypeConversionUtil.isAssignable((PsiType)componentType, (PsiType)argType)) continue;
                return false;
            }
            return true;
        } else {
            if (types.length != parameterList.getParametersCount()) {
                return false;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            for (int i = 0; i < types.length; ++i) {
                PsiType type = types[i];
                if (type == null) {
                    return false;
                }
                PsiType parameterType = parameters[i].getType();
                PsiType substitutedParameterType = substitutorForMethod.substitute(parameterType);
                if (TypeConversionUtil.isAssignable((PsiType)substitutedParameterType, (PsiType)type)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isCallToRegexMethod(PsiMethodCallExpression expression) {
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if (!regexMethodNames.contains(name)) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String className = containingClass.getQualifiedName();
        return "java.lang.String".equals(className) || "java.util.regex.Pattern".equals(className);
    }

    public static boolean isCallDuringObjectConstruction(PsiMethodCallExpression expression) {
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiMethod.class, PsiClassInitializer.class, PsiField.class});
        if (member == null) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            return false;
        }
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null || containingClass.hasModifierProperty("final")) {
            return false;
        }
        if (member instanceof PsiClassInitializer) {
            PsiClassInitializer classInitializer = (PsiClassInitializer)member;
            if (!classInitializer.hasModifierProperty("static")) {
                return true;
            }
        } else {
            PsiField field;
            if (member instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)member;
                if (method.isConstructor()) {
                    return true;
                }
                if (CloneUtils.isClone(method)) {
                    return true;
                }
                if (MethodUtils.simpleMethodMatches(method, null, "void", "readObject", "java.io.ObjectInputStream")) {
                    return true;
                }
                return MethodUtils.simpleMethodMatches(method, null, "void", "readObjectNoData", new String[0]);
            }
            if (member instanceof PsiField && !(field = (PsiField)member).hasModifierProperty("static")) {
                return true;
            }
        }
        return false;
    }

    static {
        regexMethodNames.add("compile");
        regexMethodNames.add("matches");
        regexMethodNames.add("replaceFirst");
        regexMethodNames.add("replaceAll");
        regexMethodNames.add("split");
    }
}

