/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.portability;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UseOfAWTPeerClassInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("use.of.awt.peer.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/UseOfAWTPeerClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("use.of.awt.peer.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/portability/UseOfAWTPeerClassInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UseOfAWTPeerClassVisitor();
    }

    private static class UseOfAWTPeerClassVisitor
    extends BaseInspectionVisitor {
        private UseOfAWTPeerClassVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/portability/UseOfAWTPeerClassInspection$UseOfAWTPeerClassVisitor", "visitVariable"));
            }
            super.visitVariable(variable);
            PsiType type = variable.getType();
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiType deepComponentType = type.getDeepComponentType();
            if (!(deepComponentType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)deepComponentType;
            PsiClass resolveClass = classType.resolve();
            if (resolveClass == null) {
                return;
            }
            if (resolveClass.isEnum() || resolveClass.isInterface() || resolveClass.isAnnotationType()) {
                return;
            }
            if (resolveClass instanceof PsiTypeParameter) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)resolveClass, (String)"java.awt.peer.ComponentPeer")) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
            if (newExpression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/portability/UseOfAWTPeerClassInspection$UseOfAWTPeerClassVisitor", "visitNewExpression"));
            }
            super.visitNewExpression(newExpression);
            PsiType type = newExpression.getType();
            if (type == null) {
                return;
            }
            if (!(type instanceof PsiClassType)) {
                return;
            }
            PsiClass resolveClass = ((PsiClassType)type).resolve();
            if (resolveClass == null) {
                return;
            }
            if (resolveClass.isEnum() || resolveClass.isInterface() || resolveClass.isAnnotationType()) {
                return;
            }
            if (resolveClass instanceof PsiTypeParameter) {
                return;
            }
            if (!InheritanceUtil.isInheritor((PsiClass)resolveClass, (String)"java.awt.peer.ComponentPeer")) {
                return;
            }
            this.registerNewExpressionError(newExpression, new Object[0]);
        }
    }
}

