/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class StringEqualsEmptyStringInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.equals.empty.string.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringEqualsEmptyStringInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean useIsEmpty = (Boolean)infos[0];
        if (useIsEmpty) {
            String string = InspectionGadgetsBundle.message("string.equals.empty.string.is.empty.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringEqualsEmptyStringInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("string.equals.empty.string.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringEqualsEmptyStringInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        boolean useIsEmpty = (Boolean)infos[0];
        return new StringEqualsEmptyStringFix(useIsEmpty);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringEqualsEmptyStringVisitor();
    }

    private static class StringEqualsEmptyStringVisitor
    extends BaseInspectionVisitor {
        private StringEqualsEmptyStringVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"equals".equals(methodName)) {
                return;
            }
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiElement context = call.getParent();
            boolean useIsEmpty = PsiUtil.isLanguageLevel6OrHigher((PsiElement)call);
            if (!useIsEmpty && context instanceof PsiExpressionStatement) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiExpression argument = arguments[0];
            if (ExpressionUtils.isEmptyStringLiteral(qualifier)) {
                PsiType type = argument.getType();
                if (!TypeUtils.isJavaLangString(type)) {
                    return;
                }
            } else if (ExpressionUtils.isEmptyStringLiteral(argument)) {
                if (qualifier == null) {
                    return;
                }
                PsiType type = qualifier.getType();
                if (!TypeUtils.isJavaLangString(type)) {
                    return;
                }
            } else {
                return;
            }
            this.registerMethodCallError(call, useIsEmpty);
        }
    }

    private static class StringEqualsEmptyStringFix
    extends InspectionGadgetsFix {
        private final boolean useIsEmpty;

        public StringEqualsEmptyStringFix(boolean useIsEmpty) {
            this.useIsEmpty = useIsEmpty;
        }

        @NotNull
        public String getName() {
            if (this.useIsEmpty) {
                String string = InspectionGadgetsBundle.message("string.equals.empty.string.isempty.quickfix", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringFix", "getName"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("string.equals.empty.string.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Simplify empty string check" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/StringEqualsEmptyStringInspection$StringEqualsEmptyStringFix", "getFamilyName"));
            }
            return "Simplify empty string check";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiMethodCallExpression expressionToReplace;
            StringBuilder newExpression;
            boolean addNullCheck;
            String variableText;
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            if (expression == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression.getParent();
            PsiExpressionList argumentList = call.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression qualifier = expression.getQualifierExpression();
            PsiExpression argument = arguments[0];
            if (ExpressionUtils.isEmptyStringLiteral(argument)) {
                variableText = this.getRemainingText(qualifier);
                addNullCheck = false;
            } else {
                variableText = this.getRemainingText(argument);
                addNullCheck = true;
            }
            if (addNullCheck) {
                newExpression = new StringBuilder(variableText);
                newExpression.append("!=null&&");
            } else {
                newExpression = new StringBuilder("");
            }
            PsiElement parent = call.getParent();
            if (parent instanceof PsiExpression) {
                PsiExpression parentExpression = (PsiExpression)parent;
                if (BoolUtils.isNegation(parentExpression)) {
                    expressionToReplace = parentExpression;
                    if (this.useIsEmpty) {
                        newExpression.append('!').append(variableText).append(".isEmpty()");
                    } else {
                        newExpression.append(variableText).append(".length()!=0");
                    }
                } else {
                    expressionToReplace = call;
                    if (this.useIsEmpty) {
                        newExpression.append(variableText).append(".isEmpty()");
                    } else {
                        newExpression.append(variableText).append(".length()==0");
                    }
                }
            } else {
                expressionToReplace = call;
                if (this.useIsEmpty) {
                    newExpression.append(variableText).append(".isEmpty()");
                } else {
                    newExpression.append(variableText).append(".length()==0");
                }
            }
            PsiReplacementUtil.replaceExpression((PsiExpression)expressionToReplace, newExpression.toString());
        }

        private String getRemainingText(PsiExpression expression) {
            if (this.useIsEmpty || !(expression instanceof PsiMethodCallExpression)) {
                return expression.getText();
            }
            PsiMethodCallExpression callExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression == null) {
                return expression.getText();
            }
            PsiType type = qualifierExpression.getType();
            if ("toString".equals(referenceName) && type != null && (type.equalsToText("java.lang.StringBuffer") || type.equalsToText("java.lang.StringBuilder"))) {
                return qualifierExpression.getText();
            }
            return expression.getText();
        }
    }
}

