/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.performance;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.performance.MethodReferenceVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.SerializationUtils;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class MethodMayBeStaticInspection
extends BaseInspection {
    private static final String IGNORE_DEFAULT_METHODS_ATTR_NAME = "m_ignoreDefaultMethods";
    private static final String ONLY_PRIVATE_OR_FINAL_ATTR_NAME = "m_onlyPrivateOrFinal";
    private static final String IGNORE_EMPTY_METHODS_ATTR_NAME = "m_ignoreEmptyMethods";
    public boolean m_onlyPrivateOrFinal = false;
    public boolean m_ignoreEmptyMethods = true;
    public boolean m_ignoreDefaultMethods = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.may.be.static.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/MethodMayBeStaticInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("method.may.be.static.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/performance/MethodMayBeStaticInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("static", "default");
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("method.may.be.static.only.option", new Object[0]), ONLY_PRIVATE_OR_FINAL_ATTR_NAME);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("method.may.be.static.empty.option", new Object[0]), IGNORE_EMPTY_METHODS_ATTR_NAME);
        optionsPanel.addCheckbox("Ignore default methods", IGNORE_DEFAULT_METHODS_ATTR_NAME);
        return optionsPanel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCanBeStaticVisitor();
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/performance/MethodMayBeStaticInspection", "writeSettings"));
        }
        node.addContent(new Element("option").setAttribute("name", ONLY_PRIVATE_OR_FINAL_ATTR_NAME).setAttribute("value", String.valueOf(this.m_onlyPrivateOrFinal)));
        node.addContent(new Element("option").setAttribute("name", IGNORE_EMPTY_METHODS_ATTR_NAME).setAttribute("value", String.valueOf(this.m_ignoreEmptyMethods)));
        if (!this.m_ignoreDefaultMethods) {
            node.addContent(new Element("option").setAttribute("name", IGNORE_DEFAULT_METHODS_ATTR_NAME).setAttribute("value", "false"));
        }
    }

    private class MethodCanBeStaticVisitor
    extends BaseInspectionVisitor {
        private MethodCanBeStaticVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            Condition[] addins;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/performance/MethodMayBeStaticInspection$MethodCanBeStaticVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            if (method.hasModifierProperty("static") || method.hasModifierProperty("abstract") || method.hasModifierProperty("synchronized") || method.hasModifierProperty("native")) {
                return;
            }
            if (method.isConstructor() || method.getNameIdentifier() == null) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_ignoreDefaultMethods && method.hasModifierProperty("default")) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_ignoreEmptyMethods && MethodUtils.isEmpty(method)) {
                return;
            }
            PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)method);
            if (containingClass == null) {
                return;
            }
            for (Condition addin : addins = (Condition[])InspectionManager.CANT_BE_STATIC_EXTENSION.getExtensions()) {
                if (!addin.value((Object)method)) continue;
                return;
            }
            PsiElement scope = containingClass.getScope();
            if (!(scope instanceof PsiJavaFile || containingClass.hasModifierProperty("static") || containingClass.isInterface())) {
                return;
            }
            if (MethodMayBeStaticInspection.this.m_onlyPrivateOrFinal && !method.hasModifierProperty("final") && !method.hasModifierProperty("private")) {
                return;
            }
            if (this.isExcluded(method) || MethodUtils.hasSuper(method) || MethodUtils.isOverridden(method)) {
                return;
            }
            if (this.implementsSurprisingInterface(method)) {
                return;
            }
            MethodReferenceVisitor visitor = new MethodReferenceVisitor((PsiMember)method);
            method.accept((PsiElementVisitor)visitor);
            if (!visitor.areReferencesStaticallyAccessible()) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean implementsSurprisingInterface(final PsiMethod method) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            Query search = ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)method.getUseScope(), (boolean)true, (boolean)true, (boolean)false);
            final boolean[] result = new boolean[1];
            search.forEach((Processor)new Processor<PsiClass>(){
                AtomicInteger count = new AtomicInteger(0);

                public boolean process(PsiClass subClass) {
                    PsiJavaCodeReferenceElement[] referenceElements;
                    if (this.count.incrementAndGet() > 5) {
                        result[0] = true;
                        return false;
                    }
                    PsiReferenceList list = subClass.getImplementsList();
                    if (list == null) {
                        return true;
                    }
                    for (PsiJavaCodeReferenceElement referenceElement : referenceElements = list.getReferenceElements()) {
                        PsiElement target = referenceElement.resolve();
                        if (!(target instanceof PsiClass)) {
                            result[0] = true;
                            return false;
                        }
                        PsiClass aClass = (PsiClass)target;
                        if (!aClass.isInterface()) {
                            result[0] = true;
                            return false;
                        }
                        if (aClass.findMethodBySignature(method, true) == null) continue;
                        result[0] = true;
                        return false;
                    }
                    return true;
                }
            });
            return result[0];
        }

        private boolean isExcluded(PsiMethod method) {
            return SerializationUtils.isWriteObject(method) || SerializationUtils.isReadObject(method) || SerializationUtils.isWriteReplace(method) || SerializationUtils.isReadResolve(method);
        }
    }
}

