/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class LongLiteralsEndingWithLowercaseLInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("LongLiteralEndingWithLowercaseL" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection", "getID"));
        }
        return "LongLiteralEndingWithLowercaseL";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("long.literals.ending.with.lowercase.l.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("long.literals.ending.with.lowercase.l.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new LongLiteralWithLowercaseLVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new LongLiteralFix();
    }

    private static class LongLiteralWithLowercaseLVisitor
    extends BaseInspectionVisitor {
        private LongLiteralWithLowercaseLVisitor() {
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection$LongLiteralWithLowercaseLVisitor", "visitLiteralExpression"));
            }
            super.visitLiteralExpression(expression);
            PsiType type = expression.getType();
            if (type == null) {
                return;
            }
            if (!type.equals(PsiType.LONG)) {
                return;
            }
            String text = expression.getText();
            if (text == null) {
                return;
            }
            int length = text.length();
            if (length == 0) {
                return;
            }
            if (text.charAt(length - 1) != 'l') {
                return;
            }
            this.registerError((PsiElement)expression, new Object[0]);
        }
    }

    private static class LongLiteralFix
    extends InspectionGadgetsFix {
        private LongLiteralFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("long.literals.ending.with.lowercase.l.replace.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection$LongLiteralFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/LongLiteralsEndingWithLowercaseLInspection$LongLiteralFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiExpression literal = (PsiExpression)descriptor.getPsiElement();
            String text = literal.getText();
            String newText = text.replace('l', 'L');
            PsiReplacementUtil.replaceExpression(literal, newText);
        }
    }
}

