/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class ComparisonOfShortAndCharInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("comparison.of.short.and.char.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ComparisonOfShortAndCharInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("comparison.of.short.and.char.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ComparisonOfShortAndCharInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ComparisonOfShortAndCharVisitor();
    }

    private static class ComparisonOfShortAndCharVisitor
    extends BaseInspectionVisitor {
        private ComparisonOfShortAndCharVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/numeric/ComparisonOfShortAndCharInspection$ComparisonOfShortAndCharVisitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            if (!ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiType lhsType = lhs.getType();
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiType rhsType = rhs.getType();
            if (PsiType.SHORT.equals((Object)lhsType) && PsiType.CHAR.equals((Object)rhsType)) {
                this.registerError((PsiElement)expression, new Object[0]);
            } else if (PsiType.CHAR.equals((Object)lhsType) && PsiType.SHORT.equals((Object)rhsType)) {
                this.registerError((PsiElement)expression, new Object[0]);
            }
        }
    }
}

