/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UpperCaseFieldNameNotConstantInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("upper.case.field.name.not.constant.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/UpperCaseFieldNameNotConstantInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("NonConstantFieldWithUpperCaseName" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/UpperCaseFieldNameNotConstantInspectionBase", "getID"));
        }
        return "NonConstantFieldWithUpperCaseName";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("upper.case.field.name.not.constant.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/UpperCaseFieldNameNotConstantInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UpperCaseFieldNameNotConstantVisitor();
    }

    private static class UpperCaseFieldNameNotConstantVisitor
    extends BaseInspectionVisitor {
        private UpperCaseFieldNameNotConstantVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/naming/UpperCaseFieldNameNotConstantInspectionBase$UpperCaseFieldNameNotConstantVisitor", "visitField"));
            }
            super.visitField(field);
            if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) {
                return;
            }
            String fieldName = field.getName();
            if (fieldName == null) {
                return;
            }
            if (!fieldName.equals(fieldName.toUpperCase())) {
                return;
            }
            this.registerFieldError(field, new Object[0]);
        }
    }
}

