/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.ui.ConventionOptionsPanel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPackageStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.BaseSharedLocalInspection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageNamingConventionInspection
extends BaseGlobalInspection {
    private static final int DEFAULT_MIN_LENGTH = 3;
    private static final int DEFAULT_MAX_LENGTH = 16;
    @NonNls
    public String m_regex = "[a-z]*";
    public int m_minLength = 3;
    public int m_maxLength = 16;
    protected Pattern m_regexPattern = Pattern.compile(this.m_regex);

    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("package.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/PackageNamingConventionInspection", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope analysisScope, @NotNull InspectionManager inspectionManager, @NotNull GlobalInspectionContext globalInspectionContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/naming/PackageNamingConventionInspection", "checkElement"));
        }
        if (analysisScope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/naming/PackageNamingConventionInspection", "checkElement"));
        }
        if (inspectionManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/siyeh/ig/naming/PackageNamingConventionInspection", "checkElement"));
        }
        if (globalInspectionContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/siyeh/ig/naming/PackageNamingConventionInspection", "checkElement"));
        }
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        String name = refEntity.getName();
        if ("default package".equals(name)) {
            return null;
        }
        int length = name.length();
        if (length < this.m_minLength) {
            String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.short", name);
            return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
        }
        if (length > this.m_maxLength) {
            String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.long", name);
            return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        if (matcher.matches()) {
            return null;
        }
        String errorString = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.regex.mismatch", name, this.m_regex);
        return new CommonProblemDescriptor[]{inspectionManager.createProblemDescriptor(errorString, new QuickFix[0])};
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/naming/PackageNamingConventionInspection", "readSettings"));
        }
        super.readSettings(element);
        this.m_regexPattern = Pattern.compile(this.m_regex);
    }

    public JComponent createOptionsPanel() {
        return new ConventionOptionsPanel((InspectionProfileEntry)this, "m_minLength", "m_maxLength", "m_regex", "m_regexPattern", new JComponent[0]);
    }

    boolean isValid(String name) {
        int length = name.length();
        if (length < this.m_minLength) {
            return false;
        }
        if (this.m_maxLength > 0 && length > this.m_maxLength) {
            return false;
        }
        if ("serialVersionUID".equals(name)) {
            return true;
        }
        Matcher matcher = this.m_regexPattern.matcher(name);
        return matcher.matches();
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new LocalPackageNamingConventionInspection(this);
    }

    private static class LocalPackageNamingConventionInspection
    extends BaseSharedLocalInspection<PackageNamingConventionInspection> {
        public LocalPackageNamingConventionInspection(PackageNamingConventionInspection inspection) {
            super(inspection);
        }

        @Override
        @NotNull
        protected String buildErrorString(Object ... infos) {
            String name = (String)infos[0];
            if (name.length() < ((PackageNamingConventionInspection)this.mySettingsDelegate).m_minLength) {
                String string = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.short", name);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/PackageNamingConventionInspection$LocalPackageNamingConventionInspection", "buildErrorString"));
                }
                return string;
            }
            if (name.length() > ((PackageNamingConventionInspection)this.mySettingsDelegate).m_maxLength) {
                String string = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.long", name);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/PackageNamingConventionInspection$LocalPackageNamingConventionInspection", "buildErrorString"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("package.naming.convention.problem.descriptor.regex.mismatch", name, ((PackageNamingConventionInspection)this.mySettingsDelegate).m_regex);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/PackageNamingConventionInspection$LocalPackageNamingConventionInspection", "buildErrorString"));
            }
            return string;
        }

        @Override
        public BaseInspectionVisitor buildVisitor() {
            return new BaseInspectionVisitor(){

                public void visitPackageStatement(PsiPackageStatement statement) {
                    PsiJavaCodeReferenceElement reference = statement.getPackageReference();
                    if (reference == null) {
                        return;
                    }
                    String text = reference.getText();
                    int start = 0;
                    int index = text.indexOf(46, start);
                    while (index > 0) {
                        String name = text.substring(start, index);
                        if (!((PackageNamingConventionInspection)LocalPackageNamingConventionInspection.this.mySettingsDelegate).isValid(name)) {
                            this.registerErrorAtOffset((PsiElement)reference, start, index - start, name);
                        }
                        start = index + 1;
                        index = text.indexOf(46, start);
                    }
                    String lastName = text.substring(start);
                    if (!((PackageNamingConventionInspection)LocalPackageNamingConventionInspection.this.mySettingsDelegate).isValid(lastName)) {
                        this.registerErrorAtOffset((PsiElement)reference, start, lastName.length(), lastName);
                    }
                }
            };
        }
    }
}

