/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import org.jetbrains.annotations.NotNull;

public class EnumeratedConstantNamingConventionInspectionBase
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 5;
    private static final int DEFAULT_MAX_LENGTH = 32;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("enumerated.constant.naming.convention.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/EnumeratedConstantNamingConventionInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String fieldName = (String)infos[0];
        if (fieldName.length() < this.getMinLength()) {
            String string = InspectionGadgetsBundle.message("enumerated.constant.naming.convention.problem.descriptor.short", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/EnumeratedConstantNamingConventionInspectionBase", "buildErrorString"));
            }
            return string;
        }
        if (fieldName.length() > this.getMaxLength()) {
            String string = InspectionGadgetsBundle.message("enumerated.constant.naming.convention.problem.descriptor.long", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/EnumeratedConstantNamingConventionInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("enumerated.constant.naming.convention.problem.descriptor.regex.mismatch", this.getRegex());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/naming/EnumeratedConstantNamingConventionInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Z_\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 5;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitEnumConstant(PsiEnumConstant constant) {
            super.visitEnumConstant(constant);
            String name = constant.getName();
            if (name == null) {
                return;
            }
            if (EnumeratedConstantNamingConventionInspectionBase.this.isValid(name)) {
                return;
            }
            this.registerFieldError((PsiField)constant, name);
        }
    }
}

