/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.migration;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TryFinallyCanBeTryWithResourcesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new TryFinallyCanBeTryWithResourcesFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TryFinallyCanBeTryWithResourcesVisitor();
    }

    static boolean isVariableUsedOutsideContext(PsiVariable variable, PsiElement context) {
        VariableUsedOutsideContextVisitor visitor = new VariableUsedOutsideContextVisitor(variable, context);
        PsiElement declarationScope = PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
        if (declarationScope == null) {
            return true;
        }
        declarationScope.accept((PsiElementVisitor)visitor);
        return visitor.variableIsUsed();
    }

    static List<PsiLocalVariable> collectVariables(PsiTryStatement tryStatement) {
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock == null) {
            return Collections.EMPTY_LIST;
        }
        PsiStatement[] statements = finallyBlock.getStatements();
        if (statements.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PsiLocalVariable> variables = new ArrayList<PsiLocalVariable>();
        for (PsiStatement statement : statements) {
            PsiLocalVariable variable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(statement);
            if (variable == null) continue;
            variables.add(variable);
        }
        return variables;
    }

    @Nullable
    static PsiLocalVariable findAutoCloseableVariable(PsiStatement statement) {
        if (statement instanceof PsiIfStatement) {
            PsiLocalVariable resourceVariable;
            PsiStatement thenBranch;
            PsiElement variable;
            PsiReferenceExpression referenceExpression;
            PsiIfStatement ifStatement = (PsiIfStatement)statement;
            if (ifStatement.getElseBranch() != null) {
                return null;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (!(condition instanceof PsiBinaryExpression)) {
                return null;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            if (!JavaTokenType.NE.equals(tokenType)) {
                return null;
            }
            PsiExpression lhs = binaryExpression.getLOperand();
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return null;
            }
            if (PsiType.NULL.equals((Object)rhs.getType())) {
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return null;
                }
                referenceExpression = (PsiReferenceExpression)lhs;
                variable = referenceExpression.resolve();
                if (!(variable instanceof PsiLocalVariable)) {
                    return null;
                }
            } else if (PsiType.NULL.equals((Object)lhs.getType())) {
                if (!(rhs instanceof PsiReferenceExpression)) {
                    return null;
                }
                referenceExpression = (PsiReferenceExpression)rhs;
                variable = referenceExpression.resolve();
                if (!(variable instanceof PsiLocalVariable)) {
                    return null;
                }
            } else {
                return null;
            }
            if ((thenBranch = ifStatement.getThenBranch()) instanceof PsiExpressionStatement) {
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(thenBranch);
            } else if (thenBranch instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                PsiStatement[] statements = codeBlock.getStatements();
                if (statements.length != 1) {
                    return null;
                }
                resourceVariable = TryFinallyCanBeTryWithResourcesInspection.findAutoCloseableVariable(statements[0]);
            } else {
                return null;
            }
            if (variable.equals(resourceVariable)) {
                return resourceVariable;
            }
        } else if (statement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)statement;
            PsiExpression expression = expressionStatement.getExpression();
            if (!(expression instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"close".equals(methodName)) {
                return null;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiLocalVariable) || target instanceof PsiResourceVariable) {
                return null;
            }
            PsiLocalVariable variable = (PsiLocalVariable)target;
            if (!TryFinallyCanBeTryWithResourcesInspection.isAutoCloseable((PsiVariable)variable)) {
                return null;
            }
            return variable;
        }
        return null;
    }

    private static boolean isAutoCloseable(PsiVariable variable) {
        PsiType type = variable.getType();
        if (!(type instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass aClass = classType.resolve();
        return aClass != null && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.AutoCloseable");
    }

    static int findInitialization(PsiElement[] elements, PsiVariable variable, boolean hasInitializer) {
        int result = -1;
        int statementsLength = elements.length;
        for (int i = 0; i < statementsLength; ++i) {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            PsiAssignmentExpression assignmentExpression;
            PsiExpression lhs;
            PsiExpressionStatement expressionStatement;
            PsiExpression expression;
            PsiElement element = elements[i];
            if (!(element instanceof PsiExpressionStatement) || !((expression = (expressionStatement = (PsiExpressionStatement)element).getExpression()) instanceof PsiAssignmentExpression) || !((lhs = (assignmentExpression = (PsiAssignmentExpression)expression).getLExpression()) instanceof PsiReferenceExpression) || !variable.equals(target = (referenceExpression = (PsiReferenceExpression)lhs).resolve())) continue;
            if (result >= 0 && !hasInitializer) {
                return -1;
            }
            result = i;
        }
        return result;
    }

    static class VariableUsedOutsideContextVisitor
    extends JavaRecursiveElementVisitor {
        private boolean used;
        @NotNull
        private final PsiVariable variable;
        private final PsiElement skipContext;

        public VariableUsedOutsideContextVisitor(@NotNull PsiVariable variable, PsiElement skipContext) {
            if (variable == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$VariableUsedOutsideContextVisitor", "<init>"));
            }
            this.used = false;
            this.variable = variable;
            this.skipContext = skipContext;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$VariableUsedOutsideContextVisitor", "visitElement"));
            }
            if (element.equals(this.skipContext)) {
                return;
            }
            if (this.used) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression referenceExpression) {
            if (referenceExpression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$VariableUsedOutsideContextVisitor", "visitReferenceExpression"));
            }
            if (this.used) {
                return;
            }
            super.visitReferenceExpression(referenceExpression);
            PsiElement target = referenceExpression.resolve();
            if (target == null) {
                return;
            }
            if (target.equals(this.variable) && !VariableUsedOutsideContextVisitor.isCloseMethodCalled(referenceExpression)) {
                this.used = true;
            }
        }

        private static boolean isCloseMethodCalled(PsiReferenceExpression referenceExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiMethodCallExpression.class);
            if (methodCallExpression == null) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            if (argumentList.getExpressions().length != 0) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            return "close".equals(name);
        }

        public boolean variableIsUsed() {
            return this.used;
        }
    }

    private static class TryFinallyCanBeTryWithResourcesVisitor
    extends BaseInspectionVisitor {
        private TryFinallyCanBeTryWithResourcesVisitor() {
        }

        public void visitTryStatement(PsiTryStatement tryStatement) {
            super.visitTryStatement(tryStatement);
            if (!PsiUtil.isLanguageLevel7OrHigher((PsiElement)tryStatement)) {
                return;
            }
            PsiResourceList resourceList = tryStatement.getResourceList();
            if (resourceList != null) {
                return;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            List<PsiLocalVariable> variables = TryFinallyCanBeTryWithResourcesInspection.collectVariables(tryStatement);
            if (variables.isEmpty()) {
                return;
            }
            PsiStatement[] tryBlockStatements = tryBlock.getStatements();
            boolean found = false;
            Iterator<PsiLocalVariable> i$ = variables.iterator();
            while (i$.hasNext()) {
                PsiType type;
                PsiLocalVariable variable;
                PsiExpression initializer = (variable = i$.next()).getInitializer();
                boolean hasInitializer = initializer == null ? false : !PsiType.NULL.equals((Object)(type = initializer.getType()));
                int index = TryFinallyCanBeTryWithResourcesInspection.findInitialization((PsiElement[])tryBlockStatements, (PsiVariable)variable, hasInitializer);
                if (!(index >= 0 ^ hasInitializer) || TryFinallyCanBeTryWithResourcesInspection.isVariableUsedOutsideContext((PsiVariable)variable, (PsiElement)tryBlock)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
            this.registerStatementError((PsiStatement)tryStatement, new Object[0]);
        }
    }

    private static class TryFinallyCanBeTryWithResourcesFix
    extends InspectionGadgetsFix {
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$TryFinallyCanBeTryWithResourcesFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("try.finally.can.be.try.with.resources.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/migration/TryFinallyCanBeTryWithResourcesInspection$TryFinallyCanBeTryWithResourcesFix", "getName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiCatchSection[] catchSections;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiTryStatement)) {
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return;
            }
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return;
            }
            PsiElement[] tryBlockChildren = tryBlock.getChildren();
            HashSet<PsiLocalVariable> variables = new HashSet<PsiLocalVariable>();
            for (PsiLocalVariable variable : TryFinallyCanBeTryWithResourcesInspection.collectVariables(tryStatement)) {
                if (TryFinallyCanBeTryWithResourcesInspection.isVariableUsedOutsideContext((PsiVariable)variable, (PsiElement)tryBlock)) continue;
                variables.add(variable);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            StringBuilder newTryStatementText = new StringBuilder("try (");
            HashSet<Integer> unwantedChildren = new HashSet<Integer>(2);
            boolean separator = false;
            for (PsiLocalVariable variable : variables) {
                boolean hasInitializer;
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    hasInitializer = false;
                } else {
                    PsiType type = initializer.getType();
                    boolean bl = hasInitializer = !PsiType.NULL.equals((Object)type);
                }
                if (separator) {
                    newTryStatementText.append(';');
                }
                newTryStatementText.append(variable.getTypeElement().getText()).append(' ').append(variable.getName()).append('=');
                if (hasInitializer) {
                    newTryStatementText.append(initializer.getText());
                } else {
                    PsiAssignmentExpression assignmentExpression;
                    PsiExpression rhs;
                    int index = TryFinallyCanBeTryWithResourcesInspection.findInitialization(tryBlockChildren, (PsiVariable)variable, hasInitializer);
                    if (index < 0) {
                        return;
                    }
                    unwantedChildren.add(index);
                    PsiExpressionStatement expressionStatement = (PsiExpressionStatement)tryBlockChildren[index];
                    if (expressionStatement.getNextSibling() instanceof PsiWhiteSpace) {
                        unwantedChildren.add(index + 1);
                    }
                    if ((rhs = (assignmentExpression = (PsiAssignmentExpression)expressionStatement.getExpression()).getRExpression()) == null) {
                        return;
                    }
                    newTryStatementText.append(rhs.getText());
                }
                separator = true;
            }
            newTryStatementText.append(") {");
            int tryBlockStatementsLength = tryBlockChildren.length - 1;
            for (int i = 1; i < tryBlockStatementsLength; ++i) {
                PsiElement child = tryBlockChildren[i];
                if (unwantedChildren.contains(i)) continue;
                newTryStatementText.append(child.getText());
            }
            newTryStatementText.append('}');
            for (PsiCatchSection catchSection : catchSections = tryStatement.getCatchSections()) {
                newTryStatementText.append(catchSection.getText());
            }
            PsiElement[] finallyChildren = finallyBlock.getChildren();
            boolean appended = false;
            int finallyChildrenLength = finallyChildren.length - 1;
            ArrayList<Object> savedComments = new ArrayList<Object>();
            for (int i = 1; i < finallyChildrenLength; ++i) {
                PsiElement child = finallyChildren[i];
                if (TryFinallyCanBeTryWithResourcesFix.isCloseStatement(child, variables)) continue;
                if (!appended) {
                    if (child instanceof PsiComment) {
                        PsiComment comment = (PsiComment)child;
                        PsiElement psiElement = child.getPrevSibling();
                        if (psiElement instanceof PsiWhiteSpace && savedComments.isEmpty()) {
                            savedComments.add(psiElement);
                        }
                        savedComments.add(comment);
                        PsiElement nextSibling = child.getNextSibling();
                        if (!(nextSibling instanceof PsiWhiteSpace)) continue;
                        savedComments.add(nextSibling);
                        continue;
                    }
                    if (child instanceof PsiWhiteSpace) continue;
                    newTryStatementText.append(" finally {");
                    for (PsiElement psiElement : savedComments) {
                        newTryStatementText.append(psiElement.getText());
                    }
                    newTryStatementText.append(child.getText());
                    appended = true;
                    continue;
                }
                newTryStatementText.append(child.getText());
            }
            if (appended) {
                newTryStatementText.append('}');
            }
            for (PsiLocalVariable variable : variables) {
                variable.delete();
            }
            if (!appended) {
                int savedCommentsSize = savedComments.size();
                PsiElement parent1 = tryStatement.getParent();
                for (int i = savedCommentsSize - 1; i >= 0; --i) {
                    PsiElement psiElement = (PsiElement)savedComments.get(i);
                    parent1.addAfter(psiElement, (PsiElement)tryStatement);
                }
            }
            PsiStatement newTryStatement = factory.createStatementFromText(newTryStatementText.toString(), element);
            tryStatement.replace((PsiElement)newTryStatement);
        }

        private static boolean isCloseStatement(PsiElement element, Set<PsiLocalVariable> variables) {
            if (element instanceof PsiExpressionStatement) {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)element;
                PsiExpression expression = expressionStatement.getExpression();
                if (!(expression instanceof PsiMethodCallExpression)) {
                    return false;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String methodName = methodExpression.getReferenceName();
                if (!"close".equals(methodName)) {
                    return false;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable)) {
                    return false;
                }
                PsiLocalVariable variable = (PsiLocalVariable)target;
                return variables.contains(variable);
            }
            if (element instanceof PsiIfStatement) {
                PsiStatement thenBranch;
                PsiReferenceExpression referenceExpression;
                PsiIfStatement ifStatement = (PsiIfStatement)element;
                if (ifStatement.getElseBranch() != null) {
                    return false;
                }
                PsiExpression condition = ifStatement.getCondition();
                if (!(condition instanceof PsiBinaryExpression)) {
                    return false;
                }
                PsiBinaryExpression binaryExpression = (PsiBinaryExpression)condition;
                IElementType tokenType = binaryExpression.getOperationTokenType();
                if (!JavaTokenType.NE.equals(tokenType)) {
                    return false;
                }
                PsiExpression lhs = binaryExpression.getLOperand();
                PsiExpression rhs = binaryExpression.getROperand();
                if (rhs == null) {
                    return false;
                }
                if (PsiType.NULL.equals((Object)rhs.getType())) {
                    if (!(lhs instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    referenceExpression = (PsiReferenceExpression)lhs;
                    PsiElement variable = referenceExpression.resolve();
                    if (!(variable instanceof PsiLocalVariable)) {
                        return false;
                    }
                } else if (PsiType.NULL.equals((Object)lhs.getType())) {
                    if (!(rhs instanceof PsiReferenceExpression)) {
                        return false;
                    }
                    referenceExpression = (PsiReferenceExpression)rhs;
                    PsiElement variable = referenceExpression.resolve();
                    if (!(variable instanceof PsiLocalVariable)) {
                        return false;
                    }
                } else {
                    return false;
                }
                if ((thenBranch = ifStatement.getThenBranch()) instanceof PsiExpressionStatement) {
                    return TryFinallyCanBeTryWithResourcesFix.isCloseStatement((PsiElement)thenBranch, variables);
                }
                if (thenBranch instanceof PsiBlockStatement) {
                    PsiBlockStatement blockStatement = (PsiBlockStatement)thenBranch;
                    PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
                    PsiStatement[] statements = codeBlock.getStatements();
                    return statements.length == 1 && TryFinallyCanBeTryWithResourcesFix.isCloseStatement((PsiElement)statements[0], variables);
                }
                return false;
            }
            return false;
        }
    }
}

