/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class NegationCountVisitor
extends JavaRecursiveElementVisitor {
    private final boolean myIgnoreInAssertStatements;
    private int m_count = 0;

    public NegationCountVisitor(boolean ignoreInAssertStatements) {
        this.myIgnoreInAssertStatements = ignoreInAssertStatements;
    }

    public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/NegationCountVisitor", "visitBinaryExpression"));
        }
        super.visitBinaryExpression(expression);
        IElementType tokenType = expression.getOperationTokenType();
        if (tokenType.equals(JavaTokenType.NE)) {
            ++this.m_count;
        }
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/NegationCountVisitor", "visitAnonymousClass"));
        }
    }

    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/NegationCountVisitor", "visitPrefixExpression"));
        }
        super.visitPrefixExpression(expression);
        if (expression.getOperationTokenType().equals(JavaTokenType.EXCL)) {
            ++this.m_count;
        }
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        int count = this.m_count;
        super.visitAssertStatement(statement);
        if (this.myIgnoreInAssertStatements) {
            this.m_count = count;
        }
    }

    public int getCount() {
        return this.m_count;
    }
}

