/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.methodmetrics.CouplingVisitor;
import com.siyeh.ig.methodmetrics.MethodMetricInspection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class MethodCouplingInspection
extends MethodMetricInspection {
    public boolean m_includeJavaClasses = false;
    public boolean m_includeLibraryClasses = false;

    @NotNull
    public String getID() {
        if ("OverlyCoupledMethod" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/MethodCouplingInspection", "getID"));
        }
        return "OverlyCoupledMethod";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("method.coupling.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/MethodCouplingInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer coupling = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("method.coupling.problem.descriptor", coupling);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/methodmetrics/MethodCouplingInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected int getDefaultLimit() {
        return 10;
    }

    @Override
    protected String getConfigurationLabel() {
        return InspectionGadgetsBundle.message("method.coupling.limit.option", new Object[0]);
    }

    @Override
    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        String configurationLabel = this.getConfigurationLabel();
        JLabel label = new JLabel(configurationLabel);
        JFormattedTextField valueField = this.prepareNumberEditor("m_limit");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.anchor = 17;
        constraints.fill = 0;
        panel.add((Component)label, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 18;
        constraints.fill = 0;
        panel.add((Component)valueField, constraints);
        CheckBox arrayCheckBox = new CheckBox(InspectionGadgetsBundle.message("include.java.system.classes.option", new Object[0]), (InspectionProfileEntry)this, "m_includeJavaClasses");
        CheckBox objectCheckBox = new CheckBox(InspectionGadgetsBundle.message("include.library.classes.option", new Object[0]), (InspectionProfileEntry)this, "m_includeLibraryClasses");
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 2;
        constraints.fill = 2;
        panel.add((Component)arrayCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 2;
        constraints.weighty = 1.0;
        panel.add((Component)objectCheckBox, constraints);
        return panel;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MethodCouplingVisitor();
    }

    private class MethodCouplingVisitor
    extends BaseInspectionVisitor {
        private MethodCouplingVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/MethodCouplingInspection$MethodCouplingVisitor", "visitMethod"));
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            CouplingVisitor visitor = new CouplingVisitor(method, MethodCouplingInspection.this.m_includeJavaClasses, MethodCouplingInspection.this.m_includeLibraryClasses);
            method.accept((PsiElementVisitor)visitor);
            int coupling = visitor.getNumDependencies();
            if (coupling <= MethodCouplingInspection.this.getLimit()) {
                return;
            }
            this.registerMethodError(method, coupling);
        }
    }
}

