/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CouplingVisitor
extends JavaRecursiveElementVisitor {
    private boolean m_inClass;
    private final PsiMethod m_method;
    private final boolean m_includeJavaClasses;
    private final boolean m_includeLibraryClasses;
    private final Set<String> m_dependencies;

    CouplingVisitor(@NotNull PsiMethod method, boolean includeJavaClasses, boolean includeLibraryClasses) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/CouplingVisitor", "<init>"));
        }
        this.m_inClass = false;
        this.m_dependencies = new HashSet<String>(10);
        this.m_method = method;
        this.m_includeJavaClasses = includeJavaClasses;
        this.m_includeLibraryClasses = includeLibraryClasses;
    }

    public void visitVariable(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/CouplingVisitor", "visitVariable"));
        }
        super.visitVariable(variable);
        PsiType type = variable.getType();
        this.addDependency(type);
    }

    public void visitMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/CouplingVisitor", "visitMethod"));
        }
        super.visitMethod(method);
        PsiType returnType = method.getReturnType();
        this.addDependency(returnType);
        this.addDependenciesForThrowsList(method);
    }

    private void addDependenciesForThrowsList(PsiMethod method) {
        PsiClassType[] throwsTypes;
        PsiReferenceList throwsList = method.getThrowsList();
        for (PsiClassType throwsType : throwsTypes = throwsList.getReferencedTypes()) {
            this.addDependency((PsiType)throwsType);
        }
    }

    public void visitNewExpression(@NotNull PsiNewExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/CouplingVisitor", "visitNewExpression"));
        }
        super.visitNewExpression(exp);
        PsiType classType = exp.getType();
        this.addDependency(classType);
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression exp) {
        super.visitClassObjectAccessExpression(exp);
        PsiTypeElement operand = exp.getOperand();
        this.addDependency(operand);
    }

    public void visitClass(@NotNull PsiClass aClass) {
        PsiClassType[] superTypes;
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/CouplingVisitor", "visitClass"));
        }
        boolean wasInClass = this.m_inClass;
        if (!this.m_inClass) {
            this.m_inClass = true;
            super.visitClass(aClass);
        }
        this.m_inClass = wasInClass;
        for (PsiClassType superType : superTypes = aClass.getSuperTypes()) {
            this.addDependency((PsiType)superType);
        }
    }

    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        PsiParameter[] catchBlockParameters;
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/CouplingVisitor", "visitTryStatement"));
        }
        super.visitTryStatement(statement);
        for (PsiParameter catchBlockParameter : catchBlockParameters = statement.getCatchBlockParameters()) {
            PsiType catchType = catchBlockParameter.getType();
            this.addDependency(catchType);
        }
    }

    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/CouplingVisitor", "visitInstanceOfExpression"));
        }
        super.visitInstanceOfExpression(exp);
        PsiTypeElement checkType = exp.getCheckType();
        this.addDependency(checkType);
    }

    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression exp) {
        if (exp == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/methodmetrics/CouplingVisitor", "visitTypeCastExpression"));
        }
        super.visitTypeCastExpression(exp);
        PsiTypeElement castType = exp.getCastType();
        this.addDependency(castType);
    }

    private void addDependency(PsiTypeElement typeElement) {
        if (typeElement == null) {
            return;
        }
        PsiType type = typeElement.getType();
        this.addDependency(type);
    }

    private void addDependency(PsiType type) {
        if (type == null) {
            return;
        }
        PsiType baseType = type.getDeepComponentType();
        if (ClassUtils.isPrimitive(type)) {
            return;
        }
        PsiClass containingClass = this.m_method.getContainingClass();
        if (containingClass == null) {
            return;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName == null) {
            return;
        }
        if (baseType.equalsToText(qualifiedName)) {
            return;
        }
        String baseTypeName = baseType.getCanonicalText();
        if (!this.m_includeJavaClasses && (baseTypeName.startsWith("java.") || baseTypeName.startsWith("javax."))) {
            return;
        }
        if (StringUtil.startsWithConcatenation((String)baseTypeName, (String[])new String[]{qualifiedName, "."})) {
            return;
        }
        if (!this.m_includeLibraryClasses) {
            Project project = this.m_method.getProject();
            GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(baseTypeName, searchScope);
            if (aClass == null) {
                return;
            }
            if (LibraryUtil.classIsInLibrary(aClass)) {
                return;
            }
        }
        this.m_dependencies.add(baseTypeName);
    }

    public int getNumDependencies() {
        return this.m_dependencies.size();
    }
}

