/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringConcatenationArgumentToLogCallInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> logNames = new THashSet();

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("string.concatenation.argument.to.log.call.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/StringConcatenationArgumentToLogCallInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("string.concatenation.argument.to.log.call.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/StringConcatenationArgumentToLogCallInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        if (!StringConcatenationArgumentToLogCallFix.isAvailable((PsiExpression)infos[0])) {
            return null;
        }
        return new StringConcatenationArgumentToLogCallFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationArgumentToLogCallVisitor();
    }

    static {
        logNames.add("trace");
        logNames.add("debug");
        logNames.add("info");
        logNames.add("warn");
        logNames.add("error");
    }

    private static class StringConcatenationArgumentToLogCallVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationArgumentToLogCallVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String referenceName = methodExpression.getReferenceName();
            if (!logNames.contains(referenceName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !"org.slf4j.Logger".equals(containingClass.getQualifiedName())) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            PsiExpression argument = arguments[0];
            if (!ExpressionUtils.hasStringType(argument)) {
                if (arguments.length < 2) {
                    return;
                }
                argument = arguments[1];
                if (!ExpressionUtils.hasStringType(argument)) {
                    return;
                }
            }
            if (!StringConcatenationArgumentToLogCallVisitor.containsNonConstantConcatenation(argument)) {
                return;
            }
            this.registerMethodCallError(expression, argument);
        }

        private static boolean containsNonConstantConcatenation(@Nullable PsiExpression expression) {
            if (expression instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
                return StringConcatenationArgumentToLogCallVisitor.containsNonConstantConcatenation(parenthesizedExpression.getExpression());
            }
            if (expression instanceof PsiPolyadicExpression) {
                PsiExpression[] operands;
                PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
                if (!ExpressionUtils.hasStringType((PsiExpression)polyadicExpression)) {
                    return false;
                }
                if (!JavaTokenType.PLUS.equals(polyadicExpression.getOperationTokenType())) {
                    return false;
                }
                for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                    if (ExpressionUtils.isEvaluatedAtCompileTime(operand)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class StringConcatenationArgumentToLogCallFix
    extends InspectionGadgetsFix {
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("string.concatenation.argument.to.log.call.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/StringConcatenationArgumentToLogCallInspection$StringConcatenationArgumentToLogCallFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/StringConcatenationArgumentToLogCallInspection$StringConcatenationArgumentToLogCallFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            int usedArguments;
            PsiElement element = descriptor.getPsiElement();
            PsiElement grandParent = element.getParent().getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return;
            }
            StringBuilder newMethodCall = new StringBuilder(methodCallExpression.getMethodExpression().getText());
            newMethodCall.append('(');
            PsiExpression argument = arguments[0];
            if (!(argument instanceof PsiPolyadicExpression)) {
                if (!TypeUtils.expressionHasTypeOrSubtype(argument, "org.slf4j.Marker") || arguments.length < 2) {
                    return;
                }
                newMethodCall.append(argument.getText()).append(',');
                argument = arguments[1];
                usedArguments = 2;
                if (!(argument instanceof PsiPolyadicExpression)) {
                    return;
                }
            } else {
                usedArguments = 1;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)argument;
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            PsiMethod[] methods = containingClass.findMethodsByName(methodName, false);
            boolean varArgs = false;
            for (PsiMethod otherMethod : methods) {
                if (!otherMethod.isVarArgs()) continue;
                varArgs = true;
                break;
            }
            ArrayList<PsiExpression> newArguments = new ArrayList<PsiExpression>();
            PsiExpression[] operands = polyadicExpression.getOperands();
            boolean addPlus = false;
            boolean inStringLiteral = false;
            for (PsiExpression operand : operands) {
                if (ExpressionUtils.isEvaluatedAtCompileTime(operand)) {
                    if (ExpressionUtils.hasStringType(operand) && operand instanceof PsiLiteralExpression) {
                        String text = operand.getText();
                        int count = StringUtil.getOccurrenceCount((String)text, (String)"{}");
                        for (int i = 0; i < count && usedArguments + i < arguments.length; ++i) {
                            newArguments.add(ParenthesesUtils.stripParentheses((PsiExpression)arguments[i + usedArguments].copy()));
                        }
                        usedArguments += count;
                        if (!inStringLiteral) {
                            if (addPlus) {
                                newMethodCall.append('+');
                            }
                            newMethodCall.append('\"');
                            inStringLiteral = true;
                        }
                        newMethodCall.append(text.substring(1, text.length() - 1));
                    } else {
                        if (inStringLiteral) {
                            newMethodCall.append('\"');
                            inStringLiteral = false;
                        }
                        if (addPlus) {
                            newMethodCall.append('+');
                        }
                        newMethodCall.append(operand.getText());
                    }
                } else {
                    newArguments.add(ParenthesesUtils.stripParentheses((PsiExpression)operand.copy()));
                    if (!inStringLiteral) {
                        if (addPlus) {
                            newMethodCall.append('+');
                        }
                        newMethodCall.append('\"');
                        inStringLiteral = true;
                    }
                    newMethodCall.append("{}");
                }
                addPlus = true;
            }
            while (usedArguments < arguments.length) {
                newArguments.add(arguments[usedArguments++]);
            }
            if (inStringLiteral) {
                newMethodCall.append('\"');
            }
            if (!varArgs && newArguments.size() > 2) {
                newMethodCall.append(", new Object[]{");
                boolean comma = false;
                for (PsiExpression newArgument : newArguments) {
                    if (comma) {
                        newMethodCall.append(',');
                    } else {
                        comma = true;
                    }
                    if (newArgument == null) continue;
                    newMethodCall.append(newArgument.getText());
                }
                newMethodCall.append('}');
            } else {
                for (PsiExpression newArgument : newArguments) {
                    newMethodCall.append(',');
                    if (newArgument == null) continue;
                    newMethodCall.append(newArgument.getText());
                }
            }
            newMethodCall.append(')');
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newMethodCall.toString());
        }

        public static boolean isAvailable(PsiExpression expression) {
            PsiExpression[] operands;
            if (!(expression instanceof PsiPolyadicExpression)) {
                return false;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
            for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                if (ExpressionUtils.isEvaluatedAtCompileTime(operand)) continue;
                return true;
            }
            return false;
        }
    }
}

