/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldStaticFinalFix;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NonStaticFinalLoggerInspectionBase
extends BaseInspection {
    protected final List<String> loggerClassNames = new ArrayList<String>();
    public String loggerClassName = "java.util.logging.Logger,org.slf4j.Logger,org.apache.commons.logging.Log,org.apache.log4j.Logger";

    @NotNull
    public String getID() {
        if ("NonConstantLogger" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/NonStaticFinalLoggerInspectionBase", "getID"));
        }
        return "NonConstantLogger";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.constant.logger.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/NonStaticFinalLoggerInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.constant.logger.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/logging/NonStaticFinalLoggerInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldStaticFinalFix.buildFixUnconditional(field);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/logging/NonStaticFinalLoggerInspectionBase", "readSettings"));
        }
        super.readSettings(element);
        NonStaticFinalLoggerInspectionBase.parseString(this.loggerClassName, this.loggerClassNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/logging/NonStaticFinalLoggerInspectionBase", "writeSettings"));
        }
        this.loggerClassName = NonStaticFinalLoggerInspectionBase.formatString(this.loggerClassNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonStaticFinalLoggerVisitor();
    }

    private class NonStaticFinalLoggerVisitor
    extends BaseInspectionVisitor {
        private NonStaticFinalLoggerVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField[] fields;
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/logging/NonStaticFinalLoggerInspectionBase$NonStaticFinalLoggerVisitor", "visitClass"));
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.getContainingClass() != null) {
                return;
            }
            for (PsiField field : fields = aClass.getFields()) {
                if (!this.isLogger((PsiVariable)field) || field.hasModifierProperty("static") && field.hasModifierProperty("final")) continue;
                this.registerFieldError(field, field);
            }
        }

        private boolean isLogger(PsiVariable variable) {
            PsiType type = variable.getType();
            String text = type.getCanonicalText();
            return NonStaticFinalLoggerInspectionBase.this.loggerClassNames.contains(text);
        }
    }
}

