/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TestUtils;
import org.jetbrains.annotations.NotNull;

public class TestMethodIsPublicVoidNoArgInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getID() {
        if ("TestMethodWithIncorrectSignature" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspection", "getID"));
        }
        return "TestMethodWithIncorrectSignature";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean isStatic = (Boolean)infos[1];
        if (isStatic) {
            String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor3", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspection", "buildErrorString"));
            }
            return string;
        }
        boolean takesArguments = (Boolean)infos[0];
        if (takesArguments) {
            String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor1", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("test.method.is.public.void.no.arg.problem.descriptor2", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new TestMethodIsPublicVoidNoArgVisitor();
    }

    private static class TestMethodIsPublicVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private TestMethodIsPublicVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            boolean isStatic;
            boolean takesArguments;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/junit/TestMethodIsPublicVoidNoArgInspection$TestMethodIsPublicVoidNoArgVisitor", "visitMethod"));
            }
            String methodName = method.getName();
            if (!methodName.startsWith("test") && !TestUtils.isJUnit4TestMethod(method)) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() == 0) {
                takesArguments = false;
                isStatic = method.hasModifierProperty("static");
                if (!isStatic && returnType.equals(PsiType.VOID) && method.hasModifierProperty("public")) {
                    return;
                }
            } else {
                isStatic = false;
                takesArguments = true;
            }
            PsiClass targetClass = method.getContainingClass();
            if (!(AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Test", (boolean)true) || targetClass != null && InheritanceUtil.isInheritor((PsiClass)targetClass, (String)"junit.framework.TestCase"))) {
                return;
            }
            this.registerMethodError(method, takesArguments, isStatic);
        }
    }
}

