/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageInfoWithoutPackageInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("package.info.java.without.package.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageInfoWithoutPackageInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("package.info.without.package.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageInfoWithoutPackageInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new PackageInfoWithoutPackageFix((String)infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageInfoWithoutPackageVisitor();
    }

    private static class PackageInfoWithoutPackageVisitor
    extends BaseInspectionVisitor {
        private PackageInfoWithoutPackageVisitor() {
        }

        public void visitJavaFile(PsiJavaFile file) {
            PsiDirectory directory;
            String name = file.getName();
            if (!"package-info.java".equals(name)) {
                return;
            }
            PsiPackageStatement packageStatement = file.getPackageStatement();
            if (packageStatement != null) {
                return;
            }
            JavaDirectoryService directoryService = JavaDirectoryService.getInstance();
            PsiPackage aPackage = directoryService.getPackage(directory = file.getContainingDirectory());
            if (aPackage == null) {
                return;
            }
            String packageName = aPackage.getQualifiedName();
            if (packageName.isEmpty()) {
                return;
            }
            this.registerError((PsiElement)file, packageName);
        }
    }

    private static class PackageInfoWithoutPackageFix
    extends InspectionGadgetsFix {
        private final String myPackageName;

        public PackageInfoWithoutPackageFix(String packageName) {
            this.myPackageName = packageName;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("package.info.without.package.quickfix", this.myPackageName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageInfoWithoutPackageInspection$PackageInfoWithoutPackageFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("package.info.without.package.family.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/PackageInfoWithoutPackageInspection$PackageInfoWithoutPackageFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)element;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiPackageStatement packageStatement = factory.createPackageStatement(this.myPackageName);
            file.add((PsiElement)packageStatement);
        }
    }
}

