/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.initialization;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonThreadSafeLazyInitializationInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("non.thread.safe.lazy.initialization.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/NonThreadSafeLazyInitializationInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("non.thread.safe.lazy.initialization.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/NonThreadSafeLazyInitializationInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnsafeSafeLazyInitializationVisitor();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean isApplicable = (Boolean)infos[0];
        return isApplicable ? new IntroduceHolderFix() : null;
    }

    private static class IntroduceHolderFix
    extends InspectionGadgetsFix {
        private IntroduceHolderFix() {
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiReferenceExpression expression = (PsiReferenceExpression)descriptor.getPsiElement();
            PsiElement resolved = expression.resolve();
            if (!(resolved instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)resolved;
            String holderName = IntroduceHolderFix.suggestHolderName(field);
            String text = "private static class " + holderName + " {" + "private static final " + field.getType().getCanonicalText() + " " + field.getName() + " = " + ((PsiAssignmentExpression)expression.getParent()).getRExpression().getText() + ";" + "}";
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)field.getProject()).getElementFactory();
            PsiClass holder = elementFactory.createClassFromText(text, (PsiElement)field).getInnerClasses()[0];
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            method.getParent().addBefore((PsiElement)holder, (PsiElement)method);
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class);
            ifStatement.delete();
            PsiExpression holderReference = elementFactory.createExpressionFromText(holderName + "." + field.getName(), (PsiElement)field);
            Collection references = ReferencesSearch.search((PsiElement)field).findAll();
            for (PsiReference reference : references) {
                PsiElement element = reference.getElement();
                element.replace((PsiElement)holderReference);
            }
            field.delete();
        }

        @NonNls
        private static String suggestHolderName(PsiField field) {
            String string = field.getType().getDeepComponentType().getPresentableText();
            int index = string.indexOf(60);
            if (index != -1) {
                string = string.substring(0, index);
            }
            return string + "Holder";
        }

        @NotNull
        public String getName() {
            if ("Introduce holder class" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/NonThreadSafeLazyInitializationInspection$IntroduceHolderFix", "getName"));
            }
            return "Introduce holder class";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/initialization/NonThreadSafeLazyInitializationInspection$IntroduceHolderFix", "getFamilyName"));
            }
            return string;
        }
    }

    private static class UnsafeSafeLazyInitializationVisitor
    extends BaseInspectionVisitor {
        private UnsafeSafeLazyInitializationVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/initialization/NonThreadSafeLazyInitializationInspection$UnsafeSafeLazyInitializationVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression);
            PsiExpression lhs = expression.getLExpression();
            if (!(lhs instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReference reference = (PsiReference)lhs;
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            if (UnsafeSafeLazyInitializationVisitor.isInStaticInitializer((PsiElement)expression)) {
                return;
            }
            if (UnsafeSafeLazyInitializationVisitor.isInSynchronizedContext((PsiElement)expression)) {
                return;
            }
            if (!UnsafeSafeLazyInitializationVisitor.isLazy(expression, (PsiReferenceExpression)lhs)) {
                return;
            }
            boolean assignedOnce = UnsafeSafeLazyInitializationVisitor.isAssignedOnce(referent);
            boolean safeToDelete = UnsafeSafeLazyInitializationVisitor.isSafeToDeleteIfStatement((PsiElement)expression);
            this.registerError((PsiElement)lhs, assignedOnce && safeToDelete);
        }

        private static boolean isAssignedOnce(PsiElement referent) {
            final int[] writeCount = new int[1];
            return ReferencesSearch.search((PsiElement)referent).forEach((Processor)new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiElement element = reference.getElement();
                    if (!(element instanceof PsiExpression)) {
                        return true;
                    }
                    if (!PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element))) {
                        return true;
                    }
                    writeCount[0] = writeCount[0] + 1;
                    return writeCount[0] != 2;
                }
            });
        }

        private static boolean isSafeToDeleteIfStatement(PsiElement expression) {
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class);
            if (ifStatement.getElseBranch() != null) {
                return false;
            }
            PsiStatement thenBranch = ifStatement.getThenBranch();
            if (thenBranch == null) {
                return false;
            }
            if (!(thenBranch instanceof PsiBlockStatement)) {
                return true;
            }
            return ((PsiBlockStatement)thenBranch).getCodeBlock().getStatements().length == 1;
        }

        private static boolean isLazy(PsiAssignmentExpression expression, PsiReferenceExpression lhs) {
            PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiIfStatement.class);
            if (ifStatement == null) {
                return false;
            }
            PsiExpression condition = ifStatement.getCondition();
            if (condition == null) {
                return false;
            }
            return UnsafeSafeLazyInitializationVisitor.isNullComparison(condition, lhs);
        }

        private static boolean isNullComparison(PsiExpression condition, PsiReferenceExpression reference) {
            if (!(condition instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression comparison = (PsiBinaryExpression)condition;
            IElementType tokenType = comparison.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.EQEQ)) {
                return false;
            }
            PsiExpression lhs = comparison.getLOperand();
            PsiExpression rhs = comparison.getROperand();
            if (rhs == null) {
                return false;
            }
            String lhsText = lhs.getText();
            String rhsText = rhs.getText();
            if (!"null".equals(lhsText) && !"null".equals(rhsText)) {
                return false;
            }
            String referenceText = reference.getText();
            return referenceText.equals(lhsText) || referenceText.equals(rhsText);
        }

        private static boolean isInSynchronizedContext(PsiElement element) {
            PsiSynchronizedStatement syncBlock = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiSynchronizedStatement.class);
            if (syncBlock != null) {
                return true;
            }
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
            return method != null && method.hasModifierProperty("synchronized") && method.hasModifierProperty("static");
        }

        private static boolean isInStaticInitializer(PsiElement element) {
            PsiClassInitializer initializer = (PsiClassInitializer)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClassInitializer.class);
            return initializer != null && initializer.hasModifierProperty("static");
        }
    }
}

