/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.xml.util.XmlStringUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.TestUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefusedBequestInspection
extends BaseInspection {
    public boolean ignoreEmptySuperMethods = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("refused.bequest.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("refused.bequest.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/RefusedBequestInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(XmlStringUtil.wrapInHtml((CharSequence)InspectionGadgetsBundle.message("refused.bequest.ignore.empty.super.methods.option", new Object[0])), (InspectionProfileEntry)this, "ignoreEmptySuperMethods");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new RefusedBequestVisitor();
    }

    private static class SuperCallVisitor
    extends JavaRecursiveElementVisitor {
        private final PsiMethod methodToSearchFor;
        private boolean hasSuperCall = false;

        SuperCallVisitor(PsiMethod methodToSearchFor) {
            this.methodToSearchFor = methodToSearchFor;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/inheritance/RefusedBequestInspection$SuperCallVisitor", "visitElement"));
            }
            if (this.hasSuperCall) {
                return;
            }
            super.visitElement(element);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/inheritance/RefusedBequestInspection$SuperCallVisitor", "visitMethodCallExpression"));
            }
            if (this.hasSuperCall) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            String text = qualifier.getText();
            if (!"super".equals(text)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            if (method.equals(this.methodToSearchFor)) {
                this.hasSuperCall = true;
            }
        }

        public boolean hasSuperCall() {
            return this.hasSuperCall;
        }
    }

    private class RefusedBequestVisitor
    extends BaseInspectionVisitor {
        private RefusedBequestVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiMethod superMethod;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/inheritance/RefusedBequestInspection$RefusedBequestVisitor", "visitMethod"));
            }
            super.visitMethod(method);
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiMethod leastConcreteSuperMethod = this.getLeastConcreteSuperMethod(method);
            if (leastConcreteSuperMethod == null) {
                return;
            }
            PsiClass objectClass = ClassUtils.findObjectClass((PsiElement)method);
            PsiMethod[] superMethods = method.findSuperMethods(objectClass);
            if (superMethods.length > 0) {
                return;
            }
            if (RefusedBequestInspection.this.ignoreEmptySuperMethods && this.isTrivial(superMethod = (PsiMethod)leastConcreteSuperMethod.getNavigationElement())) {
                return;
            }
            if (TestUtils.isJUnit4BeforeOrAfterMethod(method)) {
                return;
            }
            if (this.containsSuperCall((PsiElement)body, leastConcreteSuperMethod)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private boolean isTrivial(PsiMethod method) {
            PsiReturnStatement returnStatement;
            PsiExpression returnValue;
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return true;
            }
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return true;
            }
            if (statements.length > 1) {
                return false;
            }
            PsiStatement statement = statements[0];
            if (statement instanceof PsiThrowStatement) {
                return true;
            }
            return statement instanceof PsiReturnStatement && (returnValue = (returnStatement = (PsiReturnStatement)statement).getReturnValue()) instanceof PsiLiteralExpression;
        }

        @Nullable
        private PsiMethod getLeastConcreteSuperMethod(PsiMethod method) {
            PsiMethod[] superMethods;
            for (PsiMethod superMethod : superMethods = method.findSuperMethods(true)) {
                PsiClass containingClass = superMethod.getContainingClass();
                if (containingClass == null || superMethod.hasModifierProperty("abstract") || containingClass.isInterface()) continue;
                return superMethod;
            }
            return null;
        }

        private boolean containsSuperCall(@NotNull PsiElement context, @NotNull PsiMethod method) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/inheritance/RefusedBequestInspection$RefusedBequestVisitor", "containsSuperCall"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/inheritance/RefusedBequestInspection$RefusedBequestVisitor", "containsSuperCall"));
            }
            SuperCallVisitor visitor = new SuperCallVisitor(method);
            context.accept((PsiElementVisitor)visitor);
            return visitor.hasSuperCall();
        }
    }
}

