/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.imports;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class OnDemandImportInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("import.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/imports/OnDemandImportInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("import.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/imports/OnDemandImportInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PackageImportVisitor();
    }

    private static class PackageImportVisitor
    extends BaseInspectionVisitor {
        private PackageImportVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/imports/OnDemandImportInspection$PackageImportVisitor", "visitClass"));
            }
            PsiElement parent = aClass.getParent();
            if (!(parent instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)parent;
            if (FileTypeUtils.isInServerPageFile((PsiElement)aClass.getContainingFile())) {
                return;
            }
            if (!file.getClasses()[0].equals(aClass)) {
                return;
            }
            PsiImportList importList = file.getImportList();
            if (importList != null) {
                PsiImportStatement[] importStatements;
                for (PsiImportStatement importStatement : importStatements = importList.getImportStatements()) {
                    if (!importStatement.isOnDemand()) continue;
                    this.registerError((PsiElement)importStatement, new Object[0]);
                }
            }
        }
    }
}

