/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ChangeModifierFix
extends InspectionGadgetsFix {
    @PsiModifier.ModifierConstant
    private final String modifierText;
    private final String[] incompatibleModifiers;

    public ChangeModifierFix(@NonNls @PsiModifier.ModifierConstant String modifierText) {
        this.modifierText = modifierText;
        this.incompatibleModifiers = null;
    }

    public ChangeModifierFix(String modifierText, String ... incompatibleModifiers) {
        this.modifierText = modifierText;
        this.incompatibleModifiers = incompatibleModifiers;
    }

    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("change.modifier.quickfix", this.modifierText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/ChangeModifierFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Change modifier" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/ChangeModifierFix", "getFamilyName"));
        }
        return "Change modifier";
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class);
        if (modifierListOwner == null) {
            return;
        }
        PsiModifierList modifiers = modifierListOwner.getModifierList();
        if (modifiers == null) {
            return;
        }
        modifiers.setModifierProperty(this.modifierText, true);
        if (this.incompatibleModifiers != null) {
            for (String modifier : this.incompatibleModifiers) {
                modifiers.setModifierProperty(modifier, false);
            }
        }
    }
}

