/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.errorhandling.TooBroadCatchInspectionBase;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TooBroadCatchInspection
extends TooBroadCatchInspectionBase {
    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        List maskedTypes = (List)infos[0];
        ArrayList<InspectionGadgetsFix> fixes = new ArrayList<InspectionGadgetsFix>();
        for (PsiClass thrown : maskedTypes) {
            if ("java.lang.RuntimeException".equals(((PsiClass)maskedTypes.get(0)).getQualifiedName())) {
                fixes.add(new ReplaceWithRuntimeExceptionFix());
                continue;
            }
            fixes.add(new AddCatchSectionFix(thrown));
        }
        PsiElement context = (PsiElement)infos[1];
        SuppressForTestsScopeFix fix = SuppressForTestsScopeFix.build(this, context);
        if (fix != null) {
            fixes.add(fix);
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = fixes.toArray(new InspectionGadgetsFix[fixes.size()]);
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadCatchInspection", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox(InspectionGadgetsBundle.message("too.broad.catch.option", new Object[0]), "onlyWarnOnRootExceptions");
        panel.addCheckbox(InspectionGadgetsBundle.message("overly.broad.throws.clause.ignore.thrown.option", new Object[0]), "ignoreThrown");
        return panel;
    }

    private static class AddCatchSectionFix
    extends InspectionGadgetsFix {
        private final SmartPsiElementPointer<PsiClass> myThrown;
        private final String myText;

        AddCatchSectionFix(PsiClass thrown) {
            this.myThrown = SmartPointerManager.getInstance((Project)thrown.getProject()).createSmartPsiElementPointer((PsiElement)thrown);
            this.myText = thrown.getName();
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("too.broad.catch.quickfix", this.myText);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadCatchInspection$AddCatchSectionFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Add 'catch' clause" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadCatchInspection$AddCatchSectionFix", "getFamilyName"));
            }
            return "Add 'catch' clause";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement typeElement = descriptor.getPsiElement();
            if (typeElement == null) {
                return;
            }
            PsiElement catchParameter = typeElement.getParent();
            if (!(catchParameter instanceof PsiParameter)) {
                return;
            }
            PsiElement catchBlock = ((PsiParameter)catchParameter).getDeclarationScope();
            if (!(catchBlock instanceof PsiCatchSection)) {
                return;
            }
            PsiCatchSection myBeforeCatchSection = (PsiCatchSection)catchBlock;
            PsiTryStatement myTryStatement = myBeforeCatchSection.getTryStatement();
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            String name = codeStyleManager.suggestUniqueVariableName("e", (PsiElement)myTryStatement.getTryBlock(), false);
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiClass aClass = (PsiClass)this.myThrown.getElement();
            if (aClass == null) {
                return;
            }
            PsiCatchSection section = factory.createCatchSection((PsiType)factory.createType(aClass), name, (PsiElement)myTryStatement);
            PsiCatchSection element = (PsiCatchSection)myTryStatement.addBefore((PsiElement)section, (PsiElement)myBeforeCatchSection);
            codeStyleManager.shortenClassReferences((PsiElement)element);
            if (this.isOnTheFly()) {
                PsiCodeBlock newBlock = element.getCatchBlock();
                assert (newBlock != null);
                TextRange range = SurroundWithUtil.getRangeToSelect(newBlock);
                PsiFile file = element.getContainingFile();
                Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
                if (editor == null) {
                    return;
                }
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
                if (editor.getDocument() != document) {
                    return;
                }
                editor.getCaretModel().moveToOffset(range.getStartOffset());
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            }
        }
    }

    private static class ReplaceWithRuntimeExceptionFix
    extends InspectionGadgetsFix {
        private ReplaceWithRuntimeExceptionFix() {
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("replace.with.catch.clause.for.runtime.exception.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadCatchInspection$ReplaceWithRuntimeExceptionFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/TooBroadCatchInspection$ReplaceWithRuntimeExceptionFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiTypeElement)) {
                return;
            }
            PsiTypeElement typeElement = (PsiTypeElement)element;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiClassType type = factory.createTypeByFQClassName("java.lang.RuntimeException");
            PsiTypeElement newTypeElement = factory.createTypeElement((PsiType)type);
            typeElement.replace((PsiElement)newTypeElement);
        }
    }
}

