/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;

class CatchParameterUsedVisitor
extends JavaRecursiveElementVisitor {
    private final PsiParameter parameter;
    private boolean used = false;

    CatchParameterUsedVisitor(PsiParameter variable) {
        this.parameter = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/errorhandling/CatchParameterUsedVisitor", "visitElement"));
        }
        if (!this.used) {
            super.visitElement(element);
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/errorhandling/CatchParameterUsedVisitor", "visitReferenceExpression"));
        }
        if (this.used) {
            return;
        }
        super.visitReferenceExpression(reference);
        PsiElement element = reference.resolve();
        if (this.parameter.equals(element)) {
            this.used = true;
        }
    }

    public boolean isUsed() {
        return this.used;
    }
}

