/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.SwitchUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchStatementWithTooFewBranchesInspection
extends BaseInspection {
    private static final int DEFAULT_BRANCH_LIMIT = 2;
    public int m_limit = 2;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection", "getDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.min.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Integer branchCount = (Integer)infos[0];
        String string = InspectionGadgetsBundle.message("switch.statement.with.too.few.branches.problem.descriptor", branchCount);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SwitchStatementWithTooFewBranchesVisitor();
    }

    private class SwitchStatementWithTooFewBranchesVisitor
    extends BaseInspectionVisitor {
        private SwitchStatementWithTooFewBranchesVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/controlflow/SwitchStatementWithTooFewBranchesInspection$SwitchStatementWithTooFewBranchesVisitor", "visitSwitchStatement"));
            }
            PsiCodeBlock body = statement.getBody();
            if (body == null) {
                return;
            }
            int branchCount = SwitchUtils.calculateBranchCount(statement);
            if (branchCount == 0) {
                return;
            }
            if (branchCount >= SwitchStatementWithTooFewBranchesInspection.this.m_limit) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, branchCount);
        }
    }
}

