/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EmptyClassInspectionBase
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);
    public boolean ignoreClassWithParameterization = false;
    public boolean ignoreThrowables = true;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.class.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/EmptyClassInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Object element = infos[0];
        if (element instanceof PsiAnonymousClass) {
            String string = InspectionGadgetsBundle.message("empty.anonymous.class.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/EmptyClassInspectionBase", "buildErrorString"));
            }
            return string;
        }
        if (element instanceof PsiClass) {
            String string = InspectionGadgetsBundle.message("empty.class.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/EmptyClassInspectionBase", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("empty.class.file.without.class.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/EmptyClassInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        Object info = infos[0];
        if (!(info instanceof PsiModifierListOwner)) {
            if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/EmptyClassInspectionBase", "buildFixes"));
            }
            return InspectionGadgetsFix.EMPTY_ARRAY;
        }
        InspectionGadgetsFix[] inspectionGadgetsFixArray = AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)info, (List<String>)((Object)this.ignorableAnnotations));
        if (inspectionGadgetsFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/EmptyClassInspectionBase", "buildFixes"));
        }
        return inspectionGadgetsFixArray;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyClassVisitor();
    }

    private class EmptyClassVisitor
    extends BaseInspectionVisitor {
        private EmptyClassVisitor() {
        }

        public void visitFile(PsiFile file) {
            if (!(file instanceof PsiJavaFile)) {
                return;
            }
            PsiJavaFile javaFile = (PsiJavaFile)file;
            if (javaFile.getClasses().length != 0) {
                return;
            }
            String fileName = javaFile.getName();
            if ("package-info.java".equals(fileName)) {
                return;
            }
            this.registerError((PsiElement)file, file);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/classlayout/EmptyClassInspectionBase$EmptyClassVisitor", "visitClass"));
            }
            if (FileTypeUtils.isInServerPageFile((PsiElement)aClass.getContainingFile())) {
                return;
            }
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            PsiMethod[] constructors = aClass.getConstructors();
            if (constructors.length > 0) {
                return;
            }
            PsiMethod[] methods = aClass.getMethods();
            if (methods.length > 0) {
                return;
            }
            PsiField[] fields = aClass.getFields();
            if (fields.length > 0) {
                return;
            }
            PsiClassInitializer[] initializers = aClass.getInitializers();
            if (initializers.length > 0) {
                return;
            }
            if (EmptyClassInspectionBase.this.ignoreClassWithParameterization && this.isSuperParametrization(aClass)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (Collection)((Object)EmptyClassInspectionBase.this.ignorableAnnotations))) {
                return;
            }
            if (EmptyClassInspectionBase.this.ignoreThrowables && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.Throwable")) {
                return;
            }
            this.registerClassError(aClass, aClass);
        }

        private boolean hasTypeArguments(PsiReferenceList extendsList) {
            PsiJavaCodeReferenceElement[] referenceElements;
            if (extendsList == null) {
                return false;
            }
            for (PsiJavaCodeReferenceElement referenceElement : referenceElements = extendsList.getReferenceElements()) {
                PsiType[] typeArguments;
                PsiReferenceParameterList parameterList = referenceElement.getParameterList();
                if (parameterList == null || (typeArguments = parameterList.getTypeArguments()).length == 0) continue;
                return true;
            }
            return false;
        }

        private boolean isSuperParametrization(PsiClass aClass) {
            PsiTypeElement[] elements;
            if (!(aClass instanceof PsiAnonymousClass)) {
                PsiReferenceList extendsList = aClass.getExtendsList();
                PsiReferenceList implementsList = aClass.getImplementsList();
                return this.hasTypeArguments(extendsList) || this.hasTypeArguments(implementsList);
            }
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            PsiJavaCodeReferenceElement reference = anonymousClass.getBaseClassReference();
            PsiReferenceParameterList parameterList = reference.getParameterList();
            if (parameterList == null) {
                return false;
            }
            for (PsiTypeElement element : elements = parameterList.getTypeParameterElements()) {
                if (element == null) continue;
                return true;
            }
            return false;
        }
    }
}

