/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class ClassInTopLevelPackageInspectionBase
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("ClassWithoutPackageStatement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInTopLevelPackageInspectionBase", "getID"));
        }
        return "ClassWithoutPackageStatement";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("class.in.top.level.package.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInTopLevelPackageInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("class.in.top.level.package.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/classlayout/ClassInTopLevelPackageInspectionBase", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassInTopLevelPackageVisitor();
    }

    private static class ClassInTopLevelPackageVisitor
    extends BaseInspectionVisitor {
        private ClassInTopLevelPackageVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/classlayout/ClassInTopLevelPackageInspectionBase$ClassInTopLevelPackageVisitor", "visitClass"));
            }
            if (FileTypeUtils.isInServerPageFile((PsiElement)aClass)) {
                return;
            }
            if (ClassUtils.isInnerClass(aClass)) {
                return;
            }
            PsiFile file = aClass.getContainingFile();
            if (!(file instanceof PsiJavaFile)) {
                return;
            }
            if (((PsiJavaFile)file).getPackageStatement() != null) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

