/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MismatchedStringBuilderQueryUpdateInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> returnSelfNames = new HashSet<String>();

    @NotNull
    public String getID() {
        if ("MismatchedQueryAndUpdateOfStringBuilder" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection", "getID"));
        }
        return "MismatchedQueryAndUpdateOfStringBuilder";
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("mismatched.string.builder.query.update.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        boolean updated = (Boolean)infos[0];
        PsiType type = (PsiType)infos[1];
        if (updated) {
            String string = InspectionGadgetsBundle.message("mismatched.string.builder.updated.problem.descriptor", type.getPresentableText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection", "buildErrorString"));
            }
            return string;
        }
        String string = InspectionGadgetsBundle.message("mismatched.string.builder.queried.problem.descriptor", type.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection", "buildErrorString"));
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedQueryAndUpdateOfStringBuilderVisitor();
    }

    public static boolean isStringBuilderUpdated(PsiVariable variable, PsiElement context) {
        StringBuilderUpdateCalledVisitor visitor = new StringBuilderUpdateCalledVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isUpdated();
    }

    public static boolean isStringBuilderQueried(PsiVariable variable, PsiElement context) {
        StringBuilderQueryCalledVisitor visitor = new StringBuilderQueryCalledVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.isQueried();
    }

    private static boolean isVariableValueUsed(PsiExpression expression) {
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)parent;
            return MismatchedStringBuilderQueryUpdateInspection.isVariableValueUsed((PsiExpression)parenthesizedExpression);
        }
        if (parent instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            return MismatchedStringBuilderQueryUpdateInspection.isVariableValueUsed((PsiExpression)typeCastExpression);
        }
        if (parent instanceof PsiReturnStatement) {
            return true;
        }
        if (parent instanceof PsiExpressionList) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof PsiMethodCallExpression) {
                return true;
            }
        } else {
            if (parent instanceof PsiArrayInitializerExpression) {
                return true;
            }
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression rhs = assignmentExpression.getRExpression();
                return expression.equals(rhs);
            }
            if (parent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)parent;
                PsiExpression initializer = variable.getInitializer();
                return expression.equals(initializer);
            }
        }
        return false;
    }

    private static boolean hasReferenceToVariable(PsiVariable variable, PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            PsiElement target = referenceExpression.resolve();
            if (variable.equals(target)) {
                return true;
            }
        } else {
            if (element instanceof PsiParenthesizedExpression) {
                PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)element;
                PsiExpression expression = parenthesizedExpression.getExpression();
                return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)expression);
            }
            if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                String name = methodExpression.getReferenceName();
                if (returnSelfNames.contains(name)) {
                    return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)methodExpression.getQualifierExpression());
                }
            } else if (element instanceof PsiConditionalExpression) {
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
                PsiExpression thenExpression = conditionalExpression.getThenExpression();
                if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)thenExpression)) {
                    return true;
                }
                PsiExpression elseExpression = conditionalExpression.getElseExpression();
                return MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(variable, (PsiElement)elseExpression);
            }
        }
        return false;
    }

    static {
        returnSelfNames.add("append");
        returnSelfNames.add("appendCodePoint");
        returnSelfNames.add("delete");
        returnSelfNames.add("deleteCharAt");
        returnSelfNames.add("insert");
        returnSelfNames.add("replace");
        returnSelfNames.add("reverse");
    }

    private static class StringBuilderQueryCalledVisitor
    extends JavaRecursiveElementVisitor {
        @NonNls
        private static final Set<String> queryNames = new HashSet<String>();
        private final PsiVariable variable;
        private boolean queried = false;

        private StringBuilderQueryCalledVisitor(PsiVariable variable) {
            this.variable = variable;
        }

        public boolean isQueried() {
            return this.queried;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/MismatchedStringBuilderQueryUpdateInspection$StringBuilderQueryCalledVisitor", "visitElement"));
            }
            if (this.queried) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.queried) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
            if (!(parent instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (!JavaTokenType.PLUS.equals(tokenType)) {
                return;
            }
            PsiElement target = expression.resolve();
            if (!this.variable.equals(target)) {
                return;
            }
            PsiType type = polyadicExpression.getType();
            if (type == null || !type.equalsToText("java.lang.String")) {
                return;
            }
            this.queried = true;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            if (this.queried) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (!queryNames.contains(name)) {
                if (returnSelfNames.contains(name) && MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, (PsiElement)qualifierExpression) && MismatchedStringBuilderQueryUpdateInspection.isVariableValueUsed((PsiExpression)expression)) {
                    this.queried = true;
                }
                return;
            }
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, (PsiElement)qualifierExpression)) {
                this.queried = true;
            }
        }

        static {
            queryNames.add("toString");
            queryNames.add("indexOf");
            queryNames.add("lastIndexOf");
            queryNames.add("capacity");
            queryNames.add("charAt");
            queryNames.add("codePointAt");
            queryNames.add("codePointBefore");
            queryNames.add("codePointCount");
            queryNames.add("equals");
            queryNames.add("getChars");
            queryNames.add("hashCode");
            queryNames.add("length");
            queryNames.add("offsetByCodePoints");
            queryNames.add("subSequence");
            queryNames.add("substring");
        }
    }

    private static class StringBuilderUpdateCalledVisitor
    extends JavaRecursiveElementVisitor {
        @NonNls
        private static final Set<String> updateNames = new HashSet<String>();
        private final PsiVariable variable;
        boolean updated = false;

        public StringBuilderUpdateCalledVisitor(PsiVariable variable) {
            this.variable = variable;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            if (this.updated) {
                return;
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (!updateNames.contains(name)) {
                return;
            }
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (MismatchedStringBuilderQueryUpdateInspection.hasReferenceToVariable(this.variable, (PsiElement)qualifierExpression)) {
                this.updated = true;
            }
        }

        static {
            updateNames.add("append");
            updateNames.add("appendCodePoint");
            updateNames.add("delete");
            updateNames.add("delete");
            updateNames.add("deleteCharAt");
            updateNames.add("insert");
            updateNames.add("replace");
            updateNames.add("setCharAt");
        }
    }

    private static class MismatchedQueryAndUpdateOfStringBuilderVisitor
    extends BaseInspectionVisitor {
        private MismatchedQueryAndUpdateOfStringBuilderVisitor() {
        }

        public void visitField(PsiField field) {
            boolean updated;
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)field);
            if (!MismatchedQueryAndUpdateOfStringBuilderVisitor.checkVariable((PsiVariable)field, (PsiElement)containingClass)) {
                return;
            }
            boolean queried = MismatchedQueryAndUpdateOfStringBuilderVisitor.stringBuilderContentsAreQueried((PsiVariable)field, (PsiElement)containingClass);
            if (queried == (updated = MismatchedQueryAndUpdateOfStringBuilderVisitor.stringBuilderContentsAreUpdated((PsiVariable)field, (PsiElement)containingClass))) {
                return;
            }
            this.registerFieldError(field, updated, field.getType());
        }

        public void visitLocalVariable(PsiLocalVariable variable) {
            boolean updated;
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!MismatchedQueryAndUpdateOfStringBuilderVisitor.checkVariable((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            boolean queried = MismatchedQueryAndUpdateOfStringBuilderVisitor.stringBuilderContentsAreQueried((PsiVariable)variable, (PsiElement)codeBlock);
            if (queried == (updated = MismatchedQueryAndUpdateOfStringBuilderVisitor.stringBuilderContentsAreUpdated((PsiVariable)variable, (PsiElement)codeBlock))) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, updated, variable.getType());
        }

        private static boolean checkVariable(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            if (!TypeUtils.variableHasTypeOrSubtype(variable, "java.lang.AbstractStringBuilder")) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private static boolean stringBuilderContentsAreUpdated(PsiVariable variable, PsiElement context) {
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !MismatchedQueryAndUpdateOfStringBuilderVisitor.isDefaultConstructorCall(initializer)) {
                return true;
            }
            return MismatchedStringBuilderQueryUpdateInspection.isStringBuilderUpdated(variable, context);
        }

        private static boolean stringBuilderContentsAreQueried(PsiVariable variable, PsiElement context) {
            return MismatchedStringBuilderQueryUpdateInspection.isStringBuilderQueried(variable, context);
        }

        private static boolean isDefaultConstructorCall(PsiExpression initializer) {
            if (!(initializer instanceof PsiNewExpression)) {
                return false;
            }
            PsiNewExpression newExpression = (PsiNewExpression)initializer;
            PsiJavaCodeReferenceElement classReference = newExpression.getClassReference();
            if (classReference == null) {
                return false;
            }
            PsiElement target = classReference.resolve();
            if (!(target instanceof PsiClass)) {
                return false;
            }
            PsiClass aClass = (PsiClass)target;
            String qualifiedName = aClass.getQualifiedName();
            if (!"java.lang.StringBuilder".equals(qualifiedName) && !"java.lang.StringBuffer".equals(qualifiedName)) {
                return false;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 0) {
                return true;
            }
            PsiExpression argument = arguments[0];
            PsiType argumentType = argument.getType();
            return PsiType.INT.equals((Object)argumentType);
        }
    }
}

