/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class EmptyInitializerInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        if ("EmptyClassInitializer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyInitializerInspection", "getID"));
        }
        return "EmptyClassInitializer";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.class.initializer.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyInitializerInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("empty.class.initializer.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyInitializerInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EmptyInitializerFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyInitializerVisitor();
    }

    private static class EmptyInitializerVisitor
    extends BaseInspectionVisitor {
        private EmptyInitializerVisitor() {
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            if (initializer == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/EmptyInitializerInspection$EmptyInitializerVisitor", "visitClassInitializer"));
            }
            super.visitClassInitializer(initializer);
            PsiCodeBlock body = initializer.getBody();
            if (!EmptyInitializerVisitor.codeBlockIsEmpty(body)) {
                return;
            }
            this.registerClassInitializerError(initializer, new Object[0]);
        }

        private static boolean codeBlockIsEmpty(PsiCodeBlock codeBlock) {
            PsiStatement[] statements = codeBlock.getStatements();
            return statements.length == 0;
        }
    }

    private static class EmptyInitializerFix
    extends InspectionGadgetsFix {
        private EmptyInitializerFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyInitializerInspection$EmptyInitializerFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("empty.class.initializer.delete.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/EmptyInitializerInspection$EmptyInitializerFix", "getName"));
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement codeBlock = element.getParent();
            assert (codeBlock != null);
            PsiElement classInitializer = codeBlock.getParent();
            assert (classInitializer != null);
            EmptyInitializerFix.deleteElement(classInitializer);
        }
    }
}

