/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CollectionQueryCalledVisitor
extends JavaRecursiveElementVisitor {
    @NonNls
    private final Set<String> queryNames;
    private boolean queried = false;
    private final PsiVariable variable;

    CollectionQueryCalledVisitor(PsiVariable variable, Set<String> queryNames) {
        this.variable = variable;
        this.queryNames = queryNames;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/CollectionQueryCalledVisitor", "visitElement"));
        }
        if (!this.queried) {
            super.visitElement(element);
        }
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/CollectionQueryCalledVisitor", "visitForeachStatement"));
        }
        if (this.queried) {
            return;
        }
        super.visitForeachStatement(statement);
        PsiExpression qualifier = statement.getIteratedValue();
        if (!(qualifier instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReference referenceExpression = (PsiReference)qualifier;
        PsiElement referent = referenceExpression.resolve();
        if (referent == null) {
            return;
        }
        if (!referent.equals(this.variable)) {
            return;
        }
        this.queried = true;
    }

    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/bugs/CollectionQueryCalledVisitor", "visitMethodCallExpression"));
        }
        if (this.queried) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        boolean isStatement = call.getParent() instanceof PsiExpressionStatement;
        if (isStatement) {
            String methodName = methodExpression.getReferenceName();
            if (methodName == null) {
                return;
            }
            if (!this.queryNames.contains(methodName)) {
                boolean found = false;
                for (String queryName : this.queryNames) {
                    if (!methodName.startsWith(queryName)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return;
                }
            }
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        this.checkQualifier(qualifier);
    }

    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        if (this.queried) {
            return;
        }
        String methodName = expression.getReferenceName();
        if (methodName == null) {
            return;
        }
        this.checkQualifier(expression.getQualifierExpression());
    }

    private void checkQualifier(PsiExpression expression) {
        if (this.queried) {
            return;
        }
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement referent = referenceExpression.resolve();
            if (referent == null) {
                return;
            }
            if (referent.equals(this.variable)) {
                this.queried = true;
            }
        } else if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            this.checkQualifier(parenthesizedExpression.getExpression());
        } else if (expression instanceof PsiConditionalExpression) {
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)expression;
            PsiExpression thenExpression = conditionalExpression.getThenExpression();
            this.checkQualifier(thenExpression);
            PsiExpression elseExpression = conditionalExpression.getElseExpression();
            this.checkQualifier(elseExpression);
        }
    }

    public boolean isQueried() {
        return this.queried;
    }
}

