/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.assignment;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ExtractParameterAsLocalVariableFix;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignmentToMethodParameterInspection
extends BaseInspection {
    public boolean ignoreTransformationOfOriginalParameter = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("assignment.to.method.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToMethodParameterInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("assignment.to.method.parameter.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/assignment/AssignmentToMethodParameterInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("assignment.to.method.parameter.ignore.transformation.option", new Object[0]), (InspectionProfileEntry)this, "ignoreTransformationOfOriginalParameter");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ExtractParameterAsLocalVariableFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssignmentToMethodParameterVisitor();
    }

    private class AssignmentToMethodParameterVisitor
    extends BaseInspectionVisitor {
        private AssignmentToMethodParameterVisitor() {
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/assignment/AssignmentToMethodParameterInspection$AssignmentToMethodParameterVisitor", "visitAssignmentExpression"));
            }
            super.visitAssignmentExpression(expression);
            PsiExpression lhs = expression.getLExpression();
            PsiParameter parameter = this.getMethodParameter(lhs);
            if (parameter == null) {
                return;
            }
            if (AssignmentToMethodParameterInspection.this.ignoreTransformationOfOriginalParameter) {
                PsiExpression rhs = expression.getRExpression();
                if (rhs != null && VariableAccessUtils.variableIsUsed((PsiVariable)parameter, (PsiElement)rhs)) {
                    return;
                }
                IElementType tokenType = expression.getOperationTokenType();
                if (tokenType == JavaTokenType.PLUSEQ || tokenType == JavaTokenType.MINUSEQ || tokenType == JavaTokenType.ASTERISKEQ || tokenType == JavaTokenType.DIVEQ || tokenType == JavaTokenType.ANDEQ || tokenType == JavaTokenType.OREQ || tokenType == JavaTokenType.XOREQ || tokenType == JavaTokenType.PERCEQ || tokenType == JavaTokenType.LTLTEQ || tokenType == JavaTokenType.GTGTEQ || tokenType == JavaTokenType.GTGTGTEQ) {
                    return;
                }
            }
            this.registerError((PsiElement)lhs, new Object[0]);
        }

        public void visitPrefixExpression(@NotNull PsiPrefixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/assignment/AssignmentToMethodParameterInspection$AssignmentToMethodParameterVisitor", "visitPrefixExpression"));
            }
            if (AssignmentToMethodParameterInspection.this.ignoreTransformationOfOriginalParameter) {
                return;
            }
            super.visitPrefixExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiParameter parameter = this.getMethodParameter(operand);
            if (parameter == null) {
                return;
            }
            this.registerError((PsiElement)operand, new Object[0]);
        }

        public void visitPostfixExpression(@NotNull PsiPostfixExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/assignment/AssignmentToMethodParameterInspection$AssignmentToMethodParameterVisitor", "visitPostfixExpression"));
            }
            if (AssignmentToMethodParameterInspection.this.ignoreTransformationOfOriginalParameter) {
                return;
            }
            super.visitPostfixExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.PLUSPLUS) && !tokenType.equals(JavaTokenType.MINUSMINUS)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            PsiParameter parameter = this.getMethodParameter(operand);
            if (parameter == null) {
                return;
            }
            this.registerError((PsiElement)operand, new Object[0]);
        }

        @Nullable
        private PsiParameter getMethodParameter(PsiExpression expression) {
            if (!(expression instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression;
            PsiElement variable = referenceExpression.resolve();
            if (!(variable instanceof PsiParameter)) {
                return null;
            }
            PsiParameter parameter = (PsiParameter)variable;
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (declarationScope instanceof PsiCatchSection) {
                return null;
            }
            if (declarationScope instanceof PsiForeachStatement) {
                return null;
            }
            return parameter;
        }
    }
}

