/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ConcreteClassUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ParameterOfConcreteClassInspection
extends BaseInspection {
    public boolean ignoreAbstractClasses = false;

    @NotNull
    public String getID() {
        if ("MethodParameterOfConcreteClass" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/ParameterOfConcreteClassInspection", "getID"));
        }
        return "MethodParameterOfConcreteClass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("concrete.class.method.parameter.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/ParameterOfConcreteClassInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("concrete.class.method.parameter.problem.descriptor", infos);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/ParameterOfConcreteClassInspection", "buildErrorString"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("parameter.of.concrete.class.option", new Object[0]), (InspectionProfileEntry)this, "ignoreAbstractClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterOfConcreteClassVisitor();
    }

    private class ParameterOfConcreteClassVisitor
    extends BaseInspectionVisitor {
        private ParameterOfConcreteClassVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/abstraction/ParameterOfConcreteClassInspection$ParameterOfConcreteClassVisitor", "visitParameter"));
            }
            super.visitParameter(parameter);
            if (!(parameter.getDeclarationScope() instanceof PsiMethod)) {
                return;
            }
            PsiTypeElement typeElement = parameter.getTypeElement();
            if (typeElement == null) {
                return;
            }
            if (!ConcreteClassUtil.typeIsConcreteClass(typeElement, ParameterOfConcreteClassInspection.this.ignoreAbstractClasses)) {
                return;
            }
            String variableName = parameter.getName();
            this.registerError((PsiElement)typeElement, variableName);
        }
    }
}

