/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class InstanceofThisInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("instanceof.check.for.this.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofThisInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("instanceof.check.for.this.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/abstraction/InstanceofThisInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofThisVisitor();
    }

    private static class InstanceofThisVisitor
    extends BaseInspectionVisitor {
        private InstanceofThisVisitor() {
        }

        public void visitThisExpression(@NotNull PsiThisExpression thisValue) {
            if (thisValue == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/abstraction/InstanceofThisInspection$InstanceofThisVisitor", "visitThisExpression"));
            }
            super.visitThisExpression(thisValue);
            if (thisValue.getQualifier() != null) {
                return;
            }
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)thisValue, (Class[])new Class[]{PsiParenthesizedExpression.class, PsiConditionalExpression.class, PsiTypeCastExpression.class});
            if (!(parent instanceof PsiInstanceOfExpression)) {
                return;
            }
            this.registerError((PsiElement)thisValue, new Object[0]);
        }
    }
}

