/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.siyeh.ig.InspectionGadgetsPlugin;
import com.siyeh.ig.telemetry.InspectionGadgetsTelemetry;
import com.siyeh.ig.telemetry.TelemetryToolWindow;
import org.jetbrains.annotations.NotNull;

public class InspectionGadgetsProjectComponent
implements ProjectComponent {
    private final Project project;

    public InspectionGadgetsProjectComponent(Project project) {
        this.project = project;
    }

    public void projectOpened() {
        InspectionGadgetsPlugin inspectionGadgetsPlugin = InspectionGadgetsPlugin.getInstance();
        final InspectionGadgetsTelemetry telemetry = inspectionGadgetsPlugin.getTelemetry();
        boolean telemetryEnabled = InspectionGadgetsPlugin.getUpToDateTelemetryEnabled(new Consumer<Boolean>(){

            public void consume(Boolean value) {
                boolean telemetryEnabled = value;
                if (telemetryEnabled) {
                    TelemetryToolWindow toolWindow = new TelemetryToolWindow(telemetry);
                    toolWindow.register(InspectionGadgetsProjectComponent.this.project);
                } else {
                    TelemetryToolWindow.unregister(InspectionGadgetsProjectComponent.this.project);
                }
            }
        }, (Disposable)this.project);
        if (telemetryEnabled) {
            TelemetryToolWindow toolWindow = new TelemetryToolWindow(telemetry);
            toolWindow.register(this.project);
        }
    }

    public void projectClosed() {
        TelemetryToolWindow.unregister(this.project);
    }

    @NotNull
    public String getComponentName() {
        if ("InspectionGadgetsProjectComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/InspectionGadgetsProjectComponent", "getComponentName"));
        }
        return "InspectionGadgetsProjectComponent";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

