/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionGadgetsFix
implements LocalQuickFix {
    public static final InspectionGadgetsFix[] EMPTY_ARRAY = new InspectionGadgetsFix[0];
    private static final Logger LOG = Logger.getInstance((String)"#com.siyeh.ig.InspectionGadgetsFix");
    private boolean myOnTheFly = false;

    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/InspectionGadgetsFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/siyeh/ig/InspectionGadgetsFix", "applyFix"));
        }
        PsiElement problemElement = descriptor.getPsiElement();
        if (problemElement == null || !problemElement.isValid()) {
            return;
        }
        if (this.prepareForWriting() && !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{problemElement})) {
            return;
        }
        try {
            this.doFix(project, descriptor);
        }
        catch (IncorrectOperationException e) {
            Class<?> aClass = this.getClass();
            String className = aClass.getName();
            Logger logger = Logger.getInstance((String)className);
            logger.error((Throwable)e);
        }
    }

    protected boolean prepareForWriting() {
        return true;
    }

    protected abstract void doFix(Project var1, ProblemDescriptor var2);

    protected static void deleteElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/InspectionGadgetsFix", "deleteElement"));
        }
        element.delete();
    }

    protected static String getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/InspectionGadgetsFix", "getElementText"));
        }
        StringBuilder out = new StringBuilder();
        InspectionGadgetsFix.getElementText(element, elementToReplace, replacement, out);
        return out.toString();
    }

    private static void getElementText(@NotNull PsiElement element, @Nullable PsiElement elementToReplace, @Nullable String replacement, @NotNull StringBuilder out) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/siyeh/ig/InspectionGadgetsFix", "getElementText"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/siyeh/ig/InspectionGadgetsFix", "getElementText"));
        }
        if (element.equals(elementToReplace)) {
            out.append(replacement);
            return;
        }
        PsiElement[] children = element.getChildren();
        if (children.length == 0) {
            out.append(element.getText());
            return;
        }
        for (PsiElement child : children) {
            InspectionGadgetsFix.getElementText(child, elementToReplace, replacement, out);
        }
    }

    public final void setOnTheFly(boolean onTheFly) {
        this.myOnTheFly = onTheFly;
    }

    public final boolean isOnTheFly() {
        return this.myOnTheFly;
    }
}

