/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.impl.XmlEnumerationDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEnumeratedValueReference
extends PsiReferenceBase<XmlElement>
implements EmptyResolveMessageProvider {
    private final XmlEnumerationDescriptor myDescriptor;

    public XmlEnumeratedValueReference(XmlElement value, XmlEnumerationDescriptor descriptor) {
        super((PsiElement)value);
        this.myDescriptor = descriptor;
    }

    public XmlEnumeratedValueReference(XmlElement value, XmlEnumerationDescriptor descriptor, TextRange range) {
        super((PsiElement)value, range);
        this.myDescriptor = descriptor;
    }

    @Nullable
    public PsiElement resolve() {
        return this.myDescriptor.getValueDeclaration((XmlElement)this.getElement(), this.getValue());
    }

    @NotNull
    public Object[] getVariants() {
        if (this.myDescriptor.isFixed()) {
            Object[] objectArray;
            String defaultValue = this.myDescriptor.getDefaultValue();
            if (defaultValue == null) {
                objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = defaultValue;
            }
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlEnumeratedValueReference", "getVariants"));
            }
            return objectArray;
        }
        String[] values = this.myDescriptor.getEnumeratedValues();
        Object[] objectArray = values == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : values;
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlEnumeratedValueReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String name = this.getElement() instanceof XmlTag ? "tag" : "attribute";
        String string = this.myDescriptor.isFixed() ? XmlErrorMessages.message("should.have.fixed.value", StringUtil.capitalize((String)name), this.myDescriptor.getDefaultValue()) : XmlErrorMessages.message("wrong.value", name);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/util/XmlEnumeratedValueReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }
}

