/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.parsing.xml.HtmlBuilderDriver;
import com.intellij.psi.impl.source.parsing.xml.XmlBuilder;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.XmlAttributeDescriptorImpl;
import com.intellij.xml.impl.schema.XmlElementDescriptorImpl;
import com.intellij.xml.util.HTMLControls;
import com.intellij.xml.util.HtmlPsiUtil;
import com.intellij.xml.util.XmlUtil;
import com.intellij.xml.util.documentation.HtmlDescriptorsTable;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.util.HtmlUtil");
    @NonNls
    private static final String JSFC = "jsfc";
    @NonNls
    private static final String CHARSET = "charset";
    @NonNls
    private static final String CHARSET_PREFIX = "charset=";
    @NonNls
    private static final String HTML5_DATA_ATTR_PREFIX = "data-";
    public static final String SCRIPT_TAG_NAME = "script";
    public static final String[] CONTENT_TYPES = new String[]{"application/activemessage", "application/andrew-inset", "application/applefile", "application/atomicmail", "application/dca-rft", "application/dec-dx", "application/mac-binhex40", "application/mac-compactpro", "application/macwriteii", "application/msword", "application/news-message-id", "application/news-transmission", "application/octet-stream", "application/oda", "application/pdf", "application/postscript", "application/powerpoint", "application/remote-printing", "application/rtf", "application/slate", "application/wita", "application/wordperfect5.1", "application/x-bcpio", "application/x-cdlink", "application/x-compress", "application/x-cpio", "application/x-csh", "application/x-director", "application/x-dvi", "application/x-gtar", "application/x-gzip", "application/x-hdf", "application/x-httpd-cgi", "application/x-koan", "application/x-latex", "application/x-mif", "application/x-netcdf", "application/x-sh", "application/x-shar", "application/x-stuffit", "application/x-sv4cpio", "application/x-sv4crc", "application/x-tar", "application/x-tcl", "application/x-tex", "application/x-texinfo", "application/x-troff", "application/x-troff-man", "application/x-troff-me", "application/x-troff-ms", "application/x-ustar", "application/x-wais-source", "application/zip", "audio/basic", "audio/mpeg", "audio/x-aiff", "audio/x-pn-realaudio", "audio/x-pn-realaudio-plugin", "audio/x-realaudio", "audio/x-wav", "chemical/x-pdb", "image/gif", "image/ief", "image/jpeg", "image/png", "image/tiff", "image/x-cmu-raster", "image/x-portable-anymap", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap", "image/x-rgb", "image/x-xbitmap", "image/x-xpixmap", "image/x-xwindowdump", "message/external-body", "message/news", "message/partial", "message/rfc822", "multipart/alternative", "multipart/appledouble", "multipart/digest", "multipart/mixed", "multipart/parallel", "text/html", "text/plain", "text/richtext", "text/tab-separated-values", "text/x-setext", "text/x-sgml", "video/mpeg", "video/quicktime", "video/x-msvideo", "video/x-sgi-movie", "x-conference/x-cooltalk", "x-world/x-vrml"};
    @NonNls
    public static final String MATH_ML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    @NonNls
    public static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final Set<String> EMPTY_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] OPTIONAL_END_TAGS = new String[]{"head", "p", "li", "dd", "dt", "thead", "tfoot", "tbody", "colgroup", "tr", "th", "td", "option", "embed", "noembed"};
    private static final Set<String> OPTIONAL_END_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] BLOCK_TAGS = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "ul", "ol", "dir", "menu", "pre", "dl", "div", "center", "noscript", "noframes", "blockquote", "form", "isindex", "hr", "table", "fieldset", "address", "map", "body", "object", "applet", "ins", "del", "dd", "li", "button", "th", "td", "iframe", "comment", "nobr"};
    @NonNls
    private static final String[] POSSIBLY_INLINE_TAGS = new String[]{"a", "abbr", "acronym", "applet", "b", "basefont", "bdo", "big", "br", "button", "cite", "code", "del", "dfn", "em", "font", "i", "iframe", "img", "input", "ins", "kbd", "label", "map", "object", "q", "s", "samp", "select", "small", "span", "strike", "strong", "sub", "sup", "textarea", "tt", "u", "var"};
    private static final Set<String> BLOCK_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] INLINE_ELEMENTS_CONTAINER = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "pre", "dt"};
    private static final Set<String> INLINE_ELEMENTS_CONTAINER_MAP = new THashSet();
    @NonNls
    private static final String[] EMPTY_ATTRS = new String[]{"nowrap", "compact", "disabled", "readonly", "selected", "multiple", "nohref", "ismap", "declare", "noshade", "checked"};
    private static final Set<String> EMPTY_ATTRS_MAP = new THashSet();
    private static final Set<String> POSSIBLY_INLINE_TAGS_MAP = new THashSet();
    @NonNls
    private static final String[] HTML5_TAGS = new String[]{"article", "aside", "audio", "canvas", "command", "datalist", "details", "embed", "figcaption", "figure", "footer", "header", "keygen", "mark", "meter", "nav", "output", "progress", "rp", "rt", "ruby", "section", "source", "summary", "time", "video", "wbr", "main"};
    private static final Set<String> HTML5_TAGS_SET = new THashSet();
    private static final Map<String, Set<String>> AUTO_CLOSE_BY_MAP = new THashMap();

    private HtmlUtil() {
    }

    public static boolean isSingleHtmlTag(String tagName) {
        return EMPTY_TAGS_MAP.contains(tagName.toLowerCase());
    }

    public static boolean isSingleHtmlTagL(String tagName) {
        return EMPTY_TAGS_MAP.contains(tagName);
    }

    public static boolean isOptionalEndForHtmlTag(String tagName) {
        return OPTIONAL_END_TAGS_MAP.contains(tagName.toLowerCase());
    }

    public static boolean isOptionalEndForHtmlTagL(String tagName) {
        return OPTIONAL_END_TAGS_MAP.contains(tagName);
    }

    public static boolean canTerminate(String childTagName, String tagName) {
        Set<String> closingTags = AUTO_CLOSE_BY_MAP.get(tagName);
        return closingTags != null && closingTags.contains(childTagName);
    }

    public static boolean isSingleHtmlAttribute(String attrName) {
        return EMPTY_ATTRS_MAP.contains(attrName.toLowerCase());
    }

    public static boolean isHtmlBlockTag(String tagName) {
        return BLOCK_TAGS_MAP.contains(tagName.toLowerCase());
    }

    public static boolean isPossiblyInlineTag(String tagName) {
        return POSSIBLY_INLINE_TAGS_MAP.contains(tagName);
    }

    public static boolean isHtmlBlockTagL(String tagName) {
        return BLOCK_TAGS_MAP.contains(tagName);
    }

    public static boolean isInlineTagContainer(String tagName) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(tagName.toLowerCase());
    }

    public static boolean isInlineTagContainerL(String tagName) {
        return INLINE_ELEMENTS_CONTAINER_MAP.contains(tagName);
    }

    public static void addHtmlSpecificCompletions(XmlElementDescriptor descriptor, XmlTag element, List<XmlElementDescriptor> variants) {
        block4: {
            PsiElement parent;
            block5: {
                String name = descriptor.getName((PsiElement)element);
                if (name == null || !HtmlUtil.isOptionalEndForHtmlTag(name)) break block4;
                parent = element.getParent();
                if (parent != null) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof HtmlTag)) break block5;
                XmlElementDescriptor parentDescriptor = ((HtmlTag)parent).getDescriptor();
                if (parentDescriptor == descriptor || parentDescriptor == null) break block4;
                for (XmlElementDescriptor elementsDescriptor : parentDescriptor.getElementsDescriptors((XmlTag)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementsDescriptor.getName())) continue;
                    variants.add(elementsDescriptor);
                }
                break block4;
            }
            if (parent instanceof HtmlDocumentImpl) {
                XmlNSDescriptor nsDescriptor = descriptor.getNSDescriptor();
                for (XmlElementDescriptor elementDescriptor : nsDescriptor.getRootElementsDescriptors((XmlDocument)parent)) {
                    if (!HtmlUtil.isHtmlBlockTag(elementDescriptor.getName()) || variants.contains(elementDescriptor)) continue;
                    variants.add(elementDescriptor);
                }
            }
        }
    }

    @Nullable
    public static XmlDocument getRealXmlDocument(@Nullable XmlDocument doc) {
        return HtmlPsiUtil.getRealXmlDocument(doc);
    }

    public static String[] getHtmlTagNames() {
        return HtmlDescriptorsTable.getHtmlTagNames();
    }

    public static XmlAttributeDescriptor[] getCustomAttributeDescriptors(XmlElement context) {
        String entitiesString = HtmlUtil.getEntitiesString((PsiElement)context, "HtmlUnknownAttribute");
        if (entitiesString == null) {
            return XmlAttributeDescriptor.EMPTY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlAttributeDescriptor[] descriptors = new XmlAttributeDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            final String customName = tokenizer.nextToken();
            if (customName.length() == 0) continue;
            descriptors[index++] = new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context) {
                    return customName;
                }

                @Override
                public String getName() {
                    return customName;
                }
            };
        }
        return descriptors;
    }

    public static XmlElementDescriptor[] getCustomTagDescriptors(@Nullable PsiElement context) {
        String entitiesString = HtmlUtil.getEntitiesString(context, "HtmlUnknownTag");
        if (entitiesString == null) {
            return XmlElementDescriptor.EMPTY_ARRAY;
        }
        StringTokenizer tokenizer = new StringTokenizer(entitiesString, ",");
        XmlElementDescriptor[] descriptors = new XmlElementDescriptor[tokenizer.countTokens()];
        int index = 0;
        while (tokenizer.hasMoreElements()) {
            final String tagName = tokenizer.nextToken();
            if (tagName.length() == 0) continue;
            descriptors[index++] = new XmlElementDescriptorImpl(context instanceof XmlTag ? (XmlTag)context : null){

                @Override
                public String getName(PsiElement context) {
                    return tagName;
                }

                @Override
                public String getDefaultName() {
                    return tagName;
                }

                @Override
                public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
                    return true;
                }
            };
        }
        return descriptors;
    }

    @Nullable
    public static String getEntitiesString(@Nullable PsiElement context, @NotNull String inspectionName) {
        if (inspectionName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/xml/util/HtmlUtil", "getEntitiesString"));
        }
        if (context == null) {
            return null;
        }
        PsiFile containingFile = context.getContainingFile().getOriginalFile();
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(context.getProject()).getInspectionProfile();
        XmlEntitiesInspection inspection = (XmlEntitiesInspection)profile.getUnwrappedTool(inspectionName, (PsiElement)containingFile);
        if (inspection != null) {
            return inspection.getAdditionalEntries();
        }
        return null;
    }

    public static XmlAttributeDescriptor[] appendHtmlSpecificAttributeCompletions(XmlTag declarationTag, XmlAttributeDescriptor[] descriptors, XmlAttribute context) {
        if (declarationTag instanceof HtmlTag) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.mergeArrays((Object[])descriptors, (Object[])HtmlUtil.getCustomAttributeDescriptors((XmlElement)context));
            return descriptors;
        }
        boolean isJsfHtmlNamespace = false;
        for (String jsfHtmlUri : XmlUtil.JSF_HTML_URIS) {
            if (declarationTag.getPrefixByNamespace(jsfHtmlUri) == null) continue;
            isJsfHtmlNamespace = true;
            break;
        }
        if (isJsfHtmlNamespace && declarationTag.getNSDescriptor("http://www.w3.org/1999/xhtml", true) != null && !"http://java.sun.com/JSP/Page".equals(declarationTag.getNamespace())) {
            descriptors = (XmlAttributeDescriptor[])ArrayUtil.append((Object[])descriptors, (Object)new XmlAttributeDescriptorImpl(){

                @Override
                public String getName(PsiElement context) {
                    return HtmlUtil.JSFC;
                }

                @Override
                public String getName() {
                    return HtmlUtil.JSFC;
                }
            }, XmlAttributeDescriptor.class);
        }
        return descriptors;
    }

    public static boolean isHtml5Document(XmlDocument doc) {
        VirtualFile vFile;
        XmlDoctype doctype;
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype xmlDoctype = doctype = prolog != null ? prolog.getDoctype() : null;
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)doc)) {
            return false;
        }
        PsiFile htmlFile = doc.getContainingFile();
        String htmlFileFullName = htmlFile != null ? ((vFile = htmlFile.getVirtualFile()) != null ? vFile.getPath() : htmlFile.getName()) : "unknown";
        if (doctype == null) {
            LOG.debug("DOCTYPE for " + htmlFileFullName + " is null");
            return Html5SchemaProvider.getHtml5SchemaLocation().equals(ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(doc.getProject()));
        }
        boolean html5Doctype = HtmlUtil.isHtml5Doctype(doctype);
        String doctypeDescription = "text: " + doctype.getText() + ", dtdUri: " + doctype.getDtdUri() + ", publicId: " + doctype.getPublicId() + ", markupDecl: " + doctype.getMarkupDecl();
        LOG.debug("DOCTYPE for " + htmlFileFullName + "; " + doctypeDescription + "; HTML5: " + html5Doctype);
        return html5Doctype;
    }

    public static boolean isHtml5Doctype(XmlDoctype doctype) {
        return doctype.getDtdUri() == null && doctype.getPublicId() == null && doctype.getMarkupDecl() == null;
    }

    public static boolean isHtml5Context(XmlElement context) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class);
        return HtmlUtil.isHtml5Document(doc);
    }

    public static boolean isHtmlTag(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xml/util/HtmlUtil", "isHtmlTag"));
        }
        if (tag.getLanguage() != HTMLLanguage.INSTANCE) {
            return false;
        }
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlDocument.class);
        String doctype = null;
        if (doc != null) {
            doctype = XmlUtil.getDtdUri(doc);
        }
        doctype = doctype == null ? ExternalResourceManagerEx.getInstanceEx().getDefaultHtmlDoctype(tag.getProject()) : doctype;
        return XmlUtil.XHTML4_SCHEMA_LOCATION.equals(doctype) || !StringUtil.containsIgnoreCase((String)doctype, (String)"xhtml");
    }

    public static boolean hasNonHtml5Doctype(XmlElement context) {
        XmlDocument doc = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)context, XmlDocument.class);
        if (doc == null) {
            return false;
        }
        XmlProlog prolog = doc.getProlog();
        XmlDoctype doctype = prolog != null ? prolog.getDoctype() : null;
        return doctype != null && !HtmlUtil.isHtml5Doctype(doctype);
    }

    public static boolean isHtml5Tag(String tagName) {
        return HTML5_TAGS_SET.contains(tagName);
    }

    public static boolean isCustomHtml5Attribute(String attributeName) {
        return attributeName.startsWith(HTML5_DATA_ATTR_PREFIX);
    }

    @Nullable
    public static String getHrefBase(XmlFile file) {
        XmlTag root = file.getRootTag();
        XmlTag head = root != null ? root.findFirstSubTag("head") : null;
        XmlTag base = head != null ? head.findFirstSubTag("base") : null;
        return base != null ? base.getAttributeValue("href") : null;
    }

    public static boolean isOwnHtmlAttribute(XmlAttributeDescriptor descriptor) {
        PsiElement declaration = descriptor.getDeclaration();
        PsiFile file = declaration != null ? declaration.getContainingFile() : null;
        String name = file != null ? file.getName() : null;
        return "meta.rnc".equals(name);
    }

    public static Charset detectCharsetFromMetaTag(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xml/util/HtmlUtil", "detectCharsetFromMetaTag"));
        }
        int charPrefix = content.indexOf(CHARSET);
        while (true) {
            int charsetPrefixEnd;
            if (charPrefix == -1) {
                return null;
            }
            for (charsetPrefixEnd = charPrefix + CHARSET.length(); charsetPrefixEnd < content.length() && Character.isWhitespace(content.charAt(charsetPrefixEnd)); ++charsetPrefixEnd) {
            }
            if (charsetPrefixEnd < content.length() && content.charAt(charsetPrefixEnd) == '=') break;
            charPrefix = content.indexOf(CHARSET, charsetPrefixEnd);
        }
        final Ref charsetNameRef = new Ref();
        try {
            new HtmlBuilderDriver(content).build(new XmlBuilder(){
                @NonNls
                final Set<String> inTag = new THashSet();
                boolean metHttpEquiv = false;
                boolean metHttml5Charset = false;
                private String contentAttributeValue;

                @Override
                public void doctype(@Nullable CharSequence publicId, @Nullable CharSequence systemId, int startOffset, int endOffset) {
                }

                @Override
                public XmlBuilder.ProcessingOrder startTag(CharSequence localName, String namespace, int startoffset, int endoffset, int headerEndOffset) {
                    String name = ((Object)localName).toString().toLowerCase();
                    this.inTag.add(name);
                    if (!this.inTag.contains("head") && !"html".equals(name)) {
                        this.terminate();
                    }
                    return XmlBuilder.ProcessingOrder.TAGS_AND_ATTRIBUTES;
                }

                private void terminate() {
                    throw TerminateException.INSTANCE;
                }

                @Override
                public void endTag(CharSequence localName, String namespace, int startoffset, int endoffset) {
                    String name = ((Object)localName).toString().toLowerCase();
                    if ("meta".equals(name) && (this.metHttpEquiv || this.metHttml5Charset) && this.contentAttributeValue != null) {
                        String charsetName;
                        if (this.metHttpEquiv) {
                            int start = this.contentAttributeValue.indexOf(HtmlUtil.CHARSET_PREFIX);
                            if (start == -1) {
                                return;
                            }
                            int end = this.contentAttributeValue.indexOf(59, start += HtmlUtil.CHARSET_PREFIX.length());
                            if (end == -1) {
                                end = this.contentAttributeValue.length();
                            }
                            charsetName = this.contentAttributeValue.substring(start, end);
                        } else {
                            charsetName = StringUtil.stripQuotesAroundValue((String)this.contentAttributeValue);
                        }
                        charsetNameRef.set((Object)charsetName);
                        this.terminate();
                    }
                    if ("head".equals(name)) {
                        this.terminate();
                    }
                    this.inTag.remove(name);
                    this.metHttpEquiv = false;
                    this.metHttml5Charset = false;
                    this.contentAttributeValue = null;
                }

                @Override
                public void attribute(CharSequence localName, CharSequence v, int startoffset, int endoffset) {
                    String name = ((Object)localName).toString().toLowerCase();
                    if (this.inTag.contains("meta")) {
                        String value = ((Object)v).toString().toLowerCase();
                        if (name.equals("http-equiv")) {
                            this.metHttpEquiv |= value.equals("content-type");
                        } else if (name.equals(HtmlUtil.CHARSET)) {
                            this.metHttml5Charset = true;
                            this.contentAttributeValue = value;
                        }
                        if (name.equals("content")) {
                            this.contentAttributeValue = value;
                        }
                    }
                }

                @Override
                public void textElement(CharSequence display, CharSequence physical, int startoffset, int endoffset) {
                }

                @Override
                public void entityRef(CharSequence ref, int startOffset, int endOffset) {
                }

                @Override
                public void error(String message, int startOffset, int endOffset) {
                }
            });
        }
        catch (TerminateException ignored) {
        }
        catch (Exception ignored) {
            // empty catch block
        }
        String name = (String)charsetNameRef.get();
        return CharsetToolkit.forName((String)name);
    }

    public static boolean isTagWithoutAttributes(@NonNls String tagName) {
        return tagName != null && "br".equalsIgnoreCase(tagName);
    }

    public static boolean hasHtml(PsiFile file) {
        return HtmlUtil.isHtmlFile((PsiElement)file) || file.getViewProvider() instanceof TemplateLanguageFileViewProvider;
    }

    public static boolean hasHtmlPrefix(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xml/util/HtmlUtil", "hasHtmlPrefix"));
        }
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("//") || url.startsWith("ftp://");
    }

    public static boolean isHtmlFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xml/util/HtmlUtil", "isHtmlFile"));
        }
        Language language = element.getLanguage();
        return language == HTMLLanguage.INSTANCE || language == XHTMLLanguage.INSTANCE;
    }

    public static boolean isHtmlFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/xml/util/HtmlUtil", "isHtmlFile"));
        }
        FileType fileType = file.getFileType();
        return fileType == HtmlFileType.INSTANCE || fileType == XHtmlFileType.INSTANCE;
    }

    public static boolean isHtmlTagContainingFile(PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
            if (tag instanceof HtmlTag) {
                return true;
            }
            XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element, XmlDocument.class, (boolean)false);
            if (document instanceof HtmlDocumentImpl) {
                return true;
            }
            FileViewProvider provider = containingFile.getViewProvider();
            Language language = provider instanceof TemplateLanguageFileViewProvider ? ((TemplateLanguageFileViewProvider)provider).getTemplateDataLanguage() : provider.getBaseLanguage();
            return language == XHTMLLanguage.INSTANCE;
        }
        return false;
    }

    public static boolean isScriptTag(@Nullable XmlTag tag) {
        return tag != null && tag.getLocalName().equalsIgnoreCase(SCRIPT_TAG_NAME);
    }

    static {
        for (HTMLControls.Control control : HTMLControls.getControls()) {
            String tagName = control.name.toLowerCase();
            if (control.endTag == HTMLControls.TagState.FORBIDDEN) {
                EMPTY_TAGS_MAP.add(tagName);
            }
            AUTO_CLOSE_BY_MAP.put(tagName, (Set<String>)new THashSet(control.autoClosedBy));
        }
        ContainerUtil.addAll(EMPTY_ATTRS_MAP, (Object[])EMPTY_ATTRS);
        ContainerUtil.addAll(OPTIONAL_END_TAGS_MAP, (Object[])OPTIONAL_END_TAGS);
        ContainerUtil.addAll(BLOCK_TAGS_MAP, (Object[])BLOCK_TAGS);
        ContainerUtil.addAll(INLINE_ELEMENTS_CONTAINER_MAP, (Object[])INLINE_ELEMENTS_CONTAINER);
        ContainerUtil.addAll(POSSIBLY_INLINE_TAGS_MAP, (Object[])POSSIBLY_INLINE_TAGS);
        ContainerUtil.addAll(HTML5_TAGS_SET, (Object[])HTML5_TAGS);
    }

    private static class TerminateException
    extends RuntimeException {
        private static final TerminateException INSTANCE = new TerminateException();

        private TerminateException() {
        }
    }
}

